/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.refine;

import cn.vertxup.ambient.domain.tables.pojos.XActivity;
import cn.vertxup.ambient.domain.tables.pojos.XActivityChange;
import cn.vertxup.ambient.domain.tables.pojos.XNumber;
import io.horizon.specification.modeler.HAtom;
import io.horizon.spi.extension.AppInit;
import io.horizon.spi.extension.DatabaseInit;
import io.horizon.spi.extension.DatumInit;
import io.horizon.spi.extension.Init;
import io.horizon.spi.extension.SourceInit;
import io.horizon.uca.cache.Cc;
import io.horizon.uca.log.Log;
import io.horizon.uca.log.LogModule;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.AtDiffer;
import io.vertx.tp.ambient.refine.AtFs;
import io.vertx.tp.ambient.refine.AtFsDir;
import io.vertx.tp.ambient.refine.AtSerial;
import io.vertx.up.unity.Ux;
import java.util.List;

public class At {
    private static final Cc<String, Init> CC_INIT = Cc.open();

    public static Init initApp() {
        return (Init)CC_INIT.pick(AppInit::new, (Object)AppInit.class.getName());
    }

    public static Init initSource() {
        return (Init)CC_INIT.pick(SourceInit::new, (Object)SourceInit.class.getName());
    }

    public static Init initDatabase() {
        return (Init)CC_INIT.pick(DatabaseInit::new, (Object)DatabaseInit.class.getName());
    }

    public static Init initData() {
        return (Init)CC_INIT.pick(DatumInit::new, (Object)DatumInit.class.getName());
    }

    public static List<String> generate(XNumber number, Integer count) {
        return AtSerial.generate(number, count);
    }

    public static Future<List<String>> generateAsync(XNumber number, Integer count) {
        return Ux.future(AtSerial.generate(number, count));
    }

    public static XNumber serialAdjust(XNumber number, Integer count) {
        return AtSerial.adjust(number, count);
    }

    public static Future<Buffer> fileDownload(JsonArray attachment) {
        return AtFs.fileDownload(attachment);
    }

    public static Future<Buffer> fileDownload(JsonObject attachment) {
        return AtFs.fileDownload(attachment);
    }

    public static Future<JsonArray> fileUpload(JsonArray attachment) {
        return AtFs.fileUpload(attachment);
    }

    public static Future<JsonArray> fileRemove(JsonArray attachment) {
        return AtFs.fileRemove(attachment);
    }

    public static Future<JsonArray> fileDir(JsonArray attachment, JsonObject params) {
        return AtFsDir.fileDir(attachment, params);
    }

    public static Future<JsonObject> fileMeta(JsonObject appJ) {
        return AtFs.fileMeta(appJ);
    }

    public static List<XActivityChange> diffChange(JsonObject recordO, JsonObject recordN, HAtom atom) {
        return AtDiffer.diff(recordO, recordN, atom);
    }

    public static List<XActivityChange> diffChange(List<XActivityChange> changes, XActivity activity) {
        return AtDiffer.diff(changes, activity);
    }

    public static interface LOG {
        public static final String MODULE = "\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd";
        public static final LogModule App = Log.modulat((String)"\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd").program("App");
        public static final LogModule File = Log.modulat((String)"\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd").program("File");
        public static final LogModule Flow = Log.modulat((String)"\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd").program("Flow");
        public static final LogModule HES = Log.modulat((String)"\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd").program("HES");
        public static final LogModule Init = Log.modulat((String)"\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd").program("Init");
        public static final LogModule Tabb = Log.modulat((String)"\u03c0\u03b5\u03c1\u03b9\u03b2\u03ac\u03bb\u03bb\u03c9\u03bd").program("Tabb");
    }
}

