/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.refine;

import cn.vertxup.ambient.domain.tables.pojos.XActivity;
import cn.vertxup.ambient.domain.tables.pojos.XActivityChange;
import io.aeon.experiment.mu.KMarker;
import io.horizon.eon.em.typed.ChangeFlag;
import io.horizon.specification.modeler.HAtom;
import io.horizon.specification.modeler.HAttribute;
import io.horizon.uca.compare.Vs;
import io.modello.atom.typed.MetaField;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.cv.em.ActivityStatus;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

class AtDiffer {
    AtDiffer() {
    }

    static List<XActivityChange> diff(List<XActivityChange> changes, XActivity activity) {
        Objects.requireNonNull(activity);
        if (!changes.isEmpty()) {
            changes.forEach(change -> {
                change.setActivityId(activity.getKey());
                change.setStatus(ActivityStatus.CONFIRMED.name());
                Ke.umCreated((Object)change, (Object)activity);
            });
        }
        return changes;
    }

    static List<XActivityChange> diff(JsonObject recordO, JsonObject recordN, HAtom atom) {
        ChangeFlag flag = Ut.aiFlag((JsonObject)recordN, (JsonObject)recordO);
        ArrayList<XActivityChange> changes = new ArrayList<XActivityChange>();
        if (ChangeFlag.NONE != flag) {
            KMarker marker = atom.marker();
            Set fieldTrack = marker.onTrack();
            fieldTrack.stream().filter(field -> {
                Object valueN = recordN.getValue(field);
                Object valueO = recordO.getValue(field);
                return Objects.nonNull(valueN) || Objects.nonNull(valueO);
            }).forEach(field -> {
                HAttribute attribute = atom.attribute(field);
                XActivityChange change = AtDiffer.createChange(attribute);
                Object valueN = recordN.getValue(field);
                Object valueO = recordO.getValue(field);
                if (ChangeFlag.ADD == flag) {
                    change.setType(flag.name());
                    change.setValueNew(Objects.isNull(valueN) ? null : valueN.toString());
                    changes.add(change);
                } else if (ChangeFlag.DELETE == flag) {
                    change.setType(flag.name());
                    change.setValueOld(Objects.isNull(valueO) ? null : valueO.toString());
                    changes.add(change);
                } else if (ChangeFlag.UPDATE == flag) {
                    if (Objects.isNull(valueO)) {
                        change.setType(ChangeFlag.ADD.name());
                        change.setValueNew(valueN.toString());
                        changes.add(change);
                    } else if (Objects.isNull(valueN)) {
                        change.setType(ChangeFlag.DELETE.name());
                        change.setValueOld(valueO.toString());
                        changes.add(change);
                    } else {
                        Vs vs = atom.vs();
                        if (vs.isChange(valueO, valueN, field)) {
                            change.setType(ChangeFlag.UPDATE.name());
                            change.setValueNew(valueN.toString());
                            change.setValueOld(valueO.toString());
                            changes.add(change);
                        }
                    }
                }
            });
        }
        return changes;
    }

    private static XActivityChange createChange(HAttribute attribute) {
        XActivityChange change = new XActivityChange();
        change.setKey(UUID.randomUUID().toString());
        MetaField field = attribute.field();
        Objects.requireNonNull(field);
        change.setFieldName(field.name());
        change.setFieldAlias(field.alias());
        change.setFieldType(field.type().getName());
        return change;
    }
}

