/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.refine;

import io.horizon.specification.uca.HFS;
import io.horizon.spi.business.ExIo;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.atom.AtConfig;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ambient.refine.At;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;

class AtFs {
    private static final Annal LOGGER = Annal.get(AtFs.class);

    AtFs() {
    }

    static Future<JsonObject> fileMeta(JsonObject appJ) {
        AtConfig config = AtPin.getConfig();
        if (Objects.nonNull(config)) {
            appJ.put("storePath", (Object)config.getStorePath());
        }
        return Ux.futureJ((Object)appJ).compose(Fn.ofJObject((String[])new String[]{"logo"}));
    }

    static Future<Buffer> fileDownload(JsonArray attachment) {
        if (Ut.isNil((JsonArray)attachment)) {
            return Ux.future((Object)Buffer.buffer());
        }
        return AtFs.splitRun(attachment, (directoryId, fileMap) -> Ux.channel(ExIo.class, Buffer::buffer, io -> io.fsDownload(directoryId, fileMap)));
    }

    static Future<Buffer> fileDownload(JsonObject attachment) {
        String directoryId = attachment.getString("directoryId");
        String filePath = attachment.getString("filePath");
        if (Ut.ioExist((String)filePath)) {
            return Ux.future((Object)Ut.ioBuffer((String)filePath));
        }
        if (Ut.isNil((String)directoryId)) {
            return Ux.future((Object)Buffer.buffer());
        }
        String storePath = attachment.getString("storePath");
        return Ux.channel(ExIo.class, Buffer::buffer, io -> io.fsDownload(directoryId, storePath));
    }

    static Future<JsonArray> fileUpload(JsonArray attachment) {
        if (Ut.isNil((JsonArray)attachment)) {
            return Ux.futureA();
        }
        return AtFs.splitInternal(attachment, Ux::future, remote -> AtFs.splitRun(remote, (directoryId, fileMap) -> Ux.channel(ExIo.class, () -> remote, io -> io.fsUpload(directoryId, fileMap).compose(removed -> HFS.common().rmAsync(fileMap.keySet())).compose(removed -> Ux.future((Object)remote)))));
    }

    static Future<JsonArray> fileRemove(JsonArray attachment) {
        if (Ut.isNil((JsonArray)attachment)) {
            return Ux.futureA();
        }
        return AtFs.splitInternal(attachment, local -> {
            HashSet files = new HashSet();
            Ut.itJArray((JsonArray)local).forEach(each -> files.add(each.getString("filePath")));
            HFS.common().rm(files);
            At.LOG.File.info(LOGGER, "Deleted Local files: {0}", new Object[]{String.valueOf(files.size())});
            return Ux.future((Object)local);
        }, remote -> AtFs.splitRun(remote, (directoryId, fileMap) -> Ux.channel(ExIo.class, () -> remote, io -> io.fsRemove(directoryId, fileMap).compose(removed -> Ux.future((Object)remote)))));
    }

    private static <T> Future<T> splitRun(JsonArray source, BiFunction<String, ConcurrentMap<String, String>, Future<T>> executor) {
        ConcurrentHashMap fileMap = new ConcurrentHashMap();
        HashSet directorySet = new HashSet();
        Ut.itJArray((JsonArray)source).forEach(json -> {
            if (json.containsKey("directoryId")) {
                String filePath = json.getString("filePath");
                String storePath = json.getString("storePath");
                if (Ut.isNotNil((String)filePath) && Ut.isNotNil((String)storePath)) {
                    directorySet.add(json.getString("directoryId"));
                    fileMap.put(filePath, storePath);
                }
            }
        });
        return executor.apply((String)directorySet.iterator().next(), fileMap);
    }

    private static Future<JsonArray> splitInternal(JsonArray source, Function<JsonArray, Future<JsonArray>> fnLocal, Function<JsonArray, Future<JsonArray>> fnRemote) {
        JsonArray dataL = new JsonArray();
        JsonArray dataR = new JsonArray();
        Ut.itJArray((JsonArray)source).forEach(item -> {
            String directoryId = item.getString("directoryId");
            if (Ut.isNil((String)directoryId)) {
                dataL.add(item);
            } else {
                dataR.add(item);
            }
        });
        At.LOG.File.info(LOGGER, "Split Running: Local = {0}, Remote = {1}", new Object[]{dataL.size(), dataR.size()});
        ArrayList<Future<JsonArray>> futures = new ArrayList<Future<JsonArray>>();
        if (Ut.isNotNil((JsonArray)dataL)) {
            futures.add(fnLocal.apply(dataL));
        }
        if (Ut.isNotNil((JsonArray)dataR)) {
            futures.add(fnRemote.apply(dataR));
        }
        return Fn.compressA(futures);
    }
}

