/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.refine;

import cn.vertxup.ambient.service.file.DocBStub;
import cn.vertxup.ambient.service.file.DocBuilder;
import io.horizon.spi.business.ExIo;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.atom.AtConfig;
import io.vertx.tp.ambient.init.AtPin;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ambient.refine.AtFs;
import io.vertx.tp.ke.cv.em.BizInternal;
import io.vertx.up.uca.di.DiPlugin;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;

class AtFsDir {
    private static final Annal LOGGER = Annal.get(AtFsDir.class);
    private static final DiPlugin PLUGIN = DiPlugin.create(AtFs.class);

    AtFsDir() {
    }

    static Future<JsonArray> fileDir(JsonArray attachment, JsonObject params) {
        String directory = Ut.valueString((JsonArray)attachment, (String)"directory");
        String storePath = Ut.fromExpression((String)directory, (JsonObject)params);
        String sigma = params.getString("sigma");
        List paths = Ut.ioPathSet((String)storePath);
        return Ux.channel(ExIo.class, () -> null, io -> io.dirTree(sigma, paths).compose(directories -> {
            if (directories.isEmpty()) {
                return AtFsDir.seekDirectory(storePath, params);
            }
            return Ux.future((Object)directories);
        }).compose(directoryA -> {
            JsonObject input = new JsonObject();
            input.put("storePath", (Object)Ut.toJArray((List)paths));
            input.put("sigma", (Object)sigma);
            input.put("updatedBy", params.getValue("updatedBy"));
            return io.verifyIn(directoryA, input);
        })).compose(directoryJ -> {
            JsonObject verified = Ut.valueJObject((JsonObject)directoryJ);
            Ut.itJArray((JsonArray)attachment).forEach(content -> {
                content.put("directoryId", (Object)verified.getString("key"));
                content.put("storePath", (Object)Ut.ioPath((String)storePath, (String)content.getString("name")));
                content.put("storeWay", (Object)verified.getString("type"));
            });
            return Ux.future((Object)attachment);
        });
    }

    private static Future<JsonArray> seekDirectory(String storePath, JsonObject params) {
        DocBStub builder = (DocBStub)PLUGIN.createComponent(DocBuilder.class);
        String appId = params.getString("appId");
        String type = BizInternal.TypeEntity.Directory.value();
        AtConfig config = AtPin.getConfig();
        String rootPath = config.getStorePath();
        String name = storePath.replace(rootPath, "");
        name = Ut.ioPathRoot((String)name);
        At.LOG.File.info(LOGGER, "Zero will re-initialize directory try to process {0}", new Object[]{storePath});
        At.LOG.File.info(LOGGER, "The builder parameters: name = {0}, type = {1}, appId = {2}", new Object[]{name, type, appId});
        return builder.initialize(appId, type, name);
    }
}

