/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.uca.darkly;

import cn.vertxup.ambient.domain.tables.pojos.XActivity;
import cn.vertxup.ambient.domain.tables.pojos.XActivityRule;
import io.aeon.experiment.mixture.HLoad;
import io.aeon.experiment.mixture.HLoadSmart;
import io.horizon.specification.modeler.HAtom;
import io.horizon.uca.cache.Cc;
import io.horizon.uca.compare.Vs;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ambient.uca.darkly.Tube;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.uca.wffs.Playbook;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class AbstractTube
implements Tube {
    private static final Cc<String, HLoad> CC_SMART = Cc.openThread();

    protected HAtom atom(XActivityRule rule) {
        if (Objects.isNull(rule)) {
            return null;
        }
        if (Objects.isNull(rule.getRuleIdentifier())) {
            return null;
        }
        HLoad loader = (HLoad)CC_SMART.pick(HLoadSmart::new, (Object)HLoadSmart.class.getName());
        return loader.atom(rule.getRuleNs(), rule.getRuleIdentifier());
    }

    protected Future<XActivity> newActivity(JsonObject data, XActivityRule rule) {
        XActivity activity = new XActivity();
        activity.setKey(UUID.randomUUID().toString());
        activity.setType(rule.getType());
        activity.setSerial(data.getString("traceSerial"));
        data.remove("traceSerial");
        activity.setTaskName(rule.getRuleName());
        activity.setTaskSerial(data.getString("taskSerial"));
        if (data.containsKey("traceId")) {
            activity.setModelKey(data.getString("traceId"));
        } else {
            activity.setModelKey(data.getString("key"));
        }
        Ke.umCreated((Object)activity, (Object)data);
        activity.setCreatedAt(LocalDateTime.now());
        activity.setUpdatedAt(LocalDateTime.now());
        Playbook playbook = Playbook.open((String)rule.getRuleMessage());
        return playbook.format(data).compose(description -> {
            activity.setDescription((String)description);
            return Ux.future((Object)activity);
        });
    }

    protected Future<JsonObject> diffAsync(JsonObject data, XActivityRule rule, String field, Supplier<Future<JsonObject>> executor) {
        HAtom atom = this.atom(rule);
        Vs vs = atom.vs();
        JsonObject dataN = Ut.aiDataN((JsonObject)data);
        JsonObject dataO = Ut.aiDataO((JsonObject)data);
        if (vs.isChange(dataO.getValue(field), dataN.getValue(field), field)) {
            return executor.get();
        }
        At.LOG.Flow.info(this.getClass(), "The field = {0} of Atom (  identifier = {1} ) has not been changed!", new Object[]{field, atom.identifier()});
        return Ux.future((Object)data);
    }

    protected Future<JsonObject> sameAsync(JsonObject data, XActivityRule rule, String field, Supplier<Future<JsonObject>> executor) {
        HAtom atom = this.atom(rule);
        Vs vs = atom.vs();
        JsonObject dataN = Ut.aiDataN((JsonObject)data);
        JsonObject dataO = Ut.aiDataO((JsonObject)data);
        if (!vs.isChange(dataO.getValue(field), dataN.getValue(field), field)) {
            return executor.get();
        }
        At.LOG.Tabb.info(this.getClass(), "The field = {0} of Atom (  identifier = {1} ) has been changed!", new Object[]{field, atom.identifier()});
        return Ux.future((Object)data);
    }
}

