/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.uca.darkly;

import cn.vertxup.ambient.domain.tables.pojos.XActivityRule;
import io.horizon.eon.em.typed.ChangeFlag;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.cv.em.TubeType;
import io.vertx.tp.ambient.refine.At;
import io.vertx.tp.ambient.uca.darkly.AbstractTube;
import io.vertx.tp.ambient.uca.darkly.Tube;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TubeAttachment
extends AbstractTube {
    @Override
    public Future<JsonObject> traceAsync(JsonObject data, XActivityRule rule) {
        JsonObject dataN = Ut.aiDataN((JsonObject)data);
        JsonObject dataO = Ut.aiDataO((JsonObject)data);
        JsonArray fileN = Ut.valueJArray((JsonObject)dataN, (String)rule.getRuleField());
        JsonArray fileO = Ut.valueJArray((JsonObject)dataO, (String)rule.getRuleField());
        HashSet<String> fieldSet = new HashSet<String>(){
            {
                this.add("fileKey");
                this.add("fileUrl");
            }
        };
        boolean isDiff = Ut.isDiff((JsonArray)fileN, (JsonArray)fileO, (Set)fieldSet);
        At.LOG.Tabb.info(this.getClass(), "\u9644\u4ef6\u68c0\u67e5\uff1a{0}", new Object[]{isDiff});
        if (isDiff) {
            JsonObject ruleConfig = Ut.toJObject((String)rule.getRuleTpl());
            ConcurrentMap<ChangeFlag, JsonArray> diffMap = this.diff(fileN, fileO, (Set<String>)fieldSet);
            JsonObject dataIn = data.copy();
            dataIn.put("__message", (Object)this.message(diffMap, ruleConfig));
            Tube tube = Tube.instance(TubeType.EXPRESSION);
            return tube.traceAsync(dataIn, rule);
        }
        return Ux.future((Object)data);
    }

    private String message(ConcurrentMap<ChangeFlag, JsonArray> diffMap, JsonObject ruleConfig) {
        JsonArray added = (JsonArray)diffMap.get(ChangeFlag.ADD);
        StringBuilder message = new StringBuilder();
        if (Ut.isNotNil((JsonArray)added)) {
            String prefix = Ut.valueString((JsonObject)ruleConfig, (String)ChangeFlag.ADD.name());
            this.messageFormat(message, added, prefix);
        }
        message.append(",");
        JsonArray deleted = (JsonArray)diffMap.get(ChangeFlag.DELETE);
        if (Ut.isNotNil((JsonArray)deleted)) {
            String prefix = Ut.valueString((JsonObject)ruleConfig, (String)ChangeFlag.DELETE.name());
            this.messageFormat(message, deleted, prefix);
        }
        return message.toString();
    }

    private void messageFormat(StringBuilder message, JsonArray queue, String prefix) {
        if (Ut.isNotNil((JsonArray)queue)) {
            HashSet files = new HashSet();
            Ut.itJArray((JsonArray)queue).forEach(json -> {
                String filename = Ut.valueString((JsonObject)json, (String)"name");
                if (Ut.isNotNil((String)filename)) {
                    files.add(filename);
                }
            });
            if (!files.isEmpty()) {
                message.append(prefix).append(":").append(Ut.fromJoin(files, (String)","));
            }
        }
    }

    private ConcurrentMap<ChangeFlag, JsonArray> diff(JsonArray fileN, JsonArray fileO, Set<String> fields) {
        final JsonArray added = new JsonArray();
        final JsonArray deleted = new JsonArray();
        Ut.itJArray((JsonArray)fileN).forEach(jsonN -> {
            JsonObject subsetJ = Ut.elementSubset((JsonObject)jsonN, (Set)fields);
            JsonObject ifOld = Ut.elementFind((JsonArray)fileO, (JsonObject)subsetJ);
            if (Ut.isNil((JsonObject)ifOld)) {
                added.add(jsonN);
            }
        });
        Ut.itJArray((JsonArray)fileO).forEach(jsonO -> {
            JsonObject subsetJ = Ut.elementSubset((JsonObject)jsonO, (Set)fields);
            JsonObject ifNew = Ut.elementFind((JsonArray)fileN, (JsonObject)subsetJ);
            if (Ut.isNil((JsonObject)ifNew)) {
                deleted.add(jsonO);
            }
        });
        return new ConcurrentHashMap<ChangeFlag, JsonArray>(){
            {
                this.put(ChangeFlag.ADD, added);
                this.put(ChangeFlag.DELETE, deleted);
            }
        };
    }
}

