/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ambient.uca.dict;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ambient.uca.dict.Dpm;
import io.vertx.up.commune.exchange.DSource;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DpmDao
implements Dpm {
    @Override
    public Future<ConcurrentMap<String, JsonArray>> fetchAsync(DSource source, MultiMap params) {
        UxJooq jooq = this.dao(source);
        if (Objects.isNull(jooq) || Ut.isNil((String)source.getKey())) {
            return Ux.future(new ConcurrentHashMap());
        }
        return Rapid.t((String)"ZERO-CACHE-DIRECTORY", (int)300).cached((Object)source.getKey(), () -> jooq.fetchJAsync(this.condition(params))).compose(result -> {
            ConcurrentHashMap<String, JsonArray> uniqueMap = new ConcurrentHashMap<String, JsonArray>();
            uniqueMap.put(source.getKey(), (JsonArray)result);
            return Ux.future(uniqueMap);
        });
    }

    @Override
    public ConcurrentMap<String, JsonArray> fetch(DSource source, MultiMap params) {
        UxJooq jooq = this.dao(source);
        if (Objects.isNull(jooq) || Ut.isNil((String)source.getKey())) {
            return new ConcurrentHashMap<String, JsonArray>();
        }
        JsonArray result = jooq.fetchJ(this.condition(params));
        ConcurrentHashMap<String, JsonArray> uniqueMap = new ConcurrentHashMap<String, JsonArray>();
        uniqueMap.put(source.getKey(), result);
        return uniqueMap;
    }

    private JsonObject condition(MultiMap params) {
        JsonObject condition = new JsonObject();
        condition.put("sigma", (Object)params.get("sigma"));
        return condition;
    }

    private UxJooq dao(DSource source) {
        ConcurrentHashMap uniqueMap = new ConcurrentHashMap();
        Class daoCls = source.getComponent();
        if (Objects.isNull(daoCls) || Ut.isNil((String)source.getKey())) {
            return null;
        }
        JsonObject config = source.getPluginConfig();
        UxJooq jooq = Ux.Jooq.on((Class)daoCls);
        if (config.containsKey("pojo")) {
            jooq.on(config.getString("pojo"));
        }
        return jooq;
    }
}

