/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MJoin;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.element.DataKey;
import io.vertx.tp.error._417RelatedFieldMissingException;
import io.vertx.tp.error._417RelatedSchemaMissingException;
import io.vertx.up.commune.element.ShapeItem;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

class Bridge {
    Bridge() {
    }

    static void connect(Model model, Function<Schema, BiConsumer<MField, MAttribute>> consumer) {
        Ut.itCollection(model.getSchemata(), nil -> model.getAttributes(), (schema, attribute) -> Arrays.asList(schema.getFields()).forEach(field -> {
            if (Objects.isNull(attribute.getSourceField())) {
                if (field.getName().equals(attribute.getName())) {
                    ((BiConsumer)consumer.apply((Schema)schema)).accept(field, attribute);
                }
            } else if (field.getName().equals(attribute.getSourceField())) {
                ((BiConsumer)consumer.apply((Schema)schema)).accept(field, attribute);
            }
        }), (schema, attribute) -> attribute.getSource().equals(schema.identifier()));
        model.getSchemata().forEach(schema -> schema.getPrimaryKeys().forEach(field -> ((BiConsumer)consumer.apply((Schema)schema)).accept(field, Bridge.toAttribute(schema, field))));
        model.getJoins().forEach(join -> {
            String fieldKey;
            MField field;
            String identifier = join.getEntity();
            Schema schema = model.getSchema(identifier);
            if (null != schema && null != (field = schema.getField(fieldKey = join.getEntityKey())) && !field.getIsPrimary().booleanValue()) {
                ((BiConsumer)consumer.apply(schema)).accept(field, Bridge.toAttribute(schema, field));
            }
        });
    }

    private static MAttribute toAttribute(Schema schema, MField field, String name) {
        MAttribute attribute = new MAttribute();
        attribute.setName(name);
        attribute.setSource(schema.identifier());
        attribute.setSourceField(field.getName());
        return attribute;
    }

    private static MAttribute toAttribute(Schema schema, MField field) {
        return Bridge.toAttribute(schema, field, field.getName());
    }

    static List<ShapeItem> toShape(MAttribute attribute, Function<MAttribute, String> consumer) {
        JsonObject sourceConfig = Ut.toJObject((String)consumer.apply(attribute));
        JsonArray fields = Ut.sureJArray((JsonArray)sourceConfig.getJsonArray("fields"));
        ArrayList<ShapeItem> result = new ArrayList<ShapeItem>();
        if (Ut.notNil((JsonArray)fields)) {
            Ut.itJArray((JsonArray)fields).forEach(item -> {
                String field = item.getString("field");
                String alias = item.getString("alias");
                Class type = Ut.clazz((String)item.getString("type"), String.class);
                if (Ut.notNil((String)field)) {
                    result.add(ShapeItem.create((String)field, (String)alias, (Class)type));
                }
            });
        }
        return result;
    }

    static void join(Model model, Function<Schema, BiConsumer<MField, MAttribute>> consumer) {
        Set<MJoin> joins = model.getJoins();
        DataKey key = model.getKey();
        joins.forEach(join -> {
            Schema schema = model.getSchema(join.getEntity());
            String unique = model.namespace() + "-" + model.identifier();
            Fn.outWeb((null == schema ? 1 : 0) != 0, _417RelatedSchemaMissingException.class, (Object[])new Object[]{Bridge.class, join.getEntity(), key.getUnique()});
            MField field = schema.getField(join.getEntityKey());
            Fn.outWeb((null == field ? 1 : 0) != 0, _417RelatedFieldMissingException.class, (Object[])new Object[]{Bridge.class, join.getEntityKey(), join.getEntity(), key.getUnique()});
            MAttribute virtual = Bridge.toAttribute(schema, field, "pk." + schema.identifier() + "." + field.getName());
            ((BiConsumer)consumer.apply(schema)).accept(field, virtual);
        });
    }
}

