/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import io.vertx.tp.atom.cv.AoCache;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.data.MetaInfo;
import io.vertx.tp.atom.modeling.data.MetaMarker;
import io.vertx.tp.atom.modeling.data.MetaReference;
import io.vertx.tp.atom.modeling.data.MetaRule;
import io.vertx.tp.atom.modeling.data.Pool;
import io.vertx.tp.atom.modeling.reference.DataQRule;
import io.vertx.tp.atom.modeling.reference.DataQuote;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.phantom.AoPerformer;
import io.vertx.up.commune.element.CParam;
import io.vertx.up.commune.element.Shape;
import io.vertx.up.commune.rule.RuleUnique;
import io.vertx.up.fn.Fn;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DataAtom {
    private final transient AoPerformer performer;
    private final transient String unique;
    private final transient String appName;
    private final transient MetaInfo metadata;
    private final transient MetaRule ruler;
    private final transient MetaMarker marker;
    private final transient MetaReference reference;

    private DataAtom(String appName, String identifier, String unique) {
        this.appName = appName;
        this.performer = AoPerformer.getInstance(appName);
        this.unique = unique;
        Model model = (Model)Fn.pool(AoCache.POOL_MODELS, (Object)unique, () -> this.performer.fetchModel(identifier));
        Integer modelCode = model.hashCode();
        this.metadata = (MetaInfo)Fn.pool(Pool.META_INFO, (Object)modelCode, () -> new MetaInfo(model));
        this.ruler = (MetaRule)Fn.pool(Pool.META_RULE, (Object)modelCode, () -> new MetaRule(model));
        this.marker = (MetaMarker)Fn.pool(Pool.META_MARKER, (Object)modelCode, () -> new MetaMarker(model));
        this.reference = (MetaReference)Fn.pool(Pool.META_REFERENCE, (Object)modelCode, () -> new MetaReference(model));
        Ao.infoAtom(this.getClass(), "Model Information\uff1a<namespace>.<identifier> = {0}, model = {1}", unique, model.toJson().encode());
    }

    public static DataAtom get(String appName, String identifier) {
        String unique = Model.namespace(appName) + "-" + identifier;
        return new DataAtom(appName, identifier, unique);
    }

    public Set<String> attributes() {
        return this.metadata.attributes();
    }

    public ConcurrentMap<String, String> alias() {
        return this.metadata.alias();
    }

    public Model getModel() {
        return this.metadata.reference();
    }

    public String identifier() {
        return this.metadata.identifier();
    }

    public String sigma() {
        return this.metadata.sigma();
    }

    public String language() {
        return this.metadata.language();
    }

    public ConcurrentMap<String, Class<?>> type() {
        return this.metadata.type();
    }

    public Shape shape() {
        return this.metadata.shape();
    }

    public Class<?> type(String field) {
        return this.metadata.type(field);
    }

    public CParam diff() {
        return this.metadata.diff().diff(this.reference.ruleDiff());
    }

    public CParam diff(Set<String> ignoreSet) {
        return this.metadata.diff(ignoreSet).diff(this.reference.ruleDiff());
    }

    public Set<String> diffSet(String field) {
        return this.reference.ruleDiff().getOrDefault(field, new HashSet());
    }

    public RuleUnique rule() {
        return this.ruler.rule();
    }

    public RuleUnique ruleDirect() {
        return this.ruler.ruleDirect();
    }

    public RuleUnique ruleSmart() {
        return this.ruler.ruleSmart();
    }

    public DataAtom ruleConnect(RuleUnique channelRule) {
        this.ruler.connect(channelRule);
        return this;
    }

    public ConcurrentMap<DataAtom, DataQuote> ref() {
        ConcurrentHashMap<DataAtom, DataQuote> switched = new ConcurrentHashMap<DataAtom, DataQuote>();
        this.reference.references().forEach((source, quote) -> {
            DataAtom atomRef = DataAtom.get(this.appName, source);
            switched.put(atomRef, (DataQuote)quote);
        });
        return switched;
    }

    public ConcurrentMap<String, DataQRule> refRules() {
        return this.reference.rules();
    }

    public Boolean trackable() {
        return this.marker.trackable();
    }

    public Set<String> falseTrack() {
        return this.marker.track(Boolean.FALSE);
    }

    public Set<String> trueTrack() {
        return this.marker.track(Boolean.TRUE);
    }

    public Set<String> falseIn() {
        return this.marker.in(Boolean.FALSE);
    }

    public Set<String> trueIn() {
        return this.marker.in(Boolean.TRUE);
    }

    public Set<String> falseOut() {
        return this.marker.out(Boolean.FALSE);
    }

    public Set<String> trueOut() {
        return this.marker.out(Boolean.TRUE);
    }

    public Set<String> falseConfirm() {
        return this.marker.confirm(Boolean.FALSE);
    }

    public Set<String> trueConfirm() {
        return this.marker.confirm(Boolean.TRUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataAtom)) {
            return false;
        }
        DataAtom atom = (DataAtom)o;
        return this.unique.equals(atom.unique);
    }

    public int hashCode() {
        return Objects.hash(this.unique);
    }
}

