/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.cv.em.EventType;
import io.vertx.tp.atom.cv.em.ModelType;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.data.Bridge;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.data.Debug;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.error._417DataRowNullException;
import io.vertx.tp.modular.io.AoIo;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.tp.modular.ray.AoRay;
import io.vertx.tp.modular.ray.RayBatch;
import io.vertx.tp.modular.ray.RaySingle;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.commune.Json;
import io.vertx.up.commune.Record;
import io.vertx.up.exception.WebException;
import io.vertx.up.fn.Fn;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DataEvent
implements Serializable {
    private final transient DataAtom atom;
    private final transient DataTpl tpl;
    private final transient Set<String> projection = new HashSet<String>();
    private transient WebException exception;
    private transient AoIo io;
    private transient Criteria criteria;
    private transient Inquiry inquiry;
    private transient long counter;

    private DataEvent(DataAtom atom, AoSentence sentence) {
        this.atom = atom;
        Model model = atom.getModel();
        this.tpl = DataTpl.create().on(sentence).on(atom);
        Bridge.connect(model, schema -> (field, attribute) -> this.tpl.initTpl((Schema)schema, (MField)field, (MAttribute)attribute));
        Bridge.join(model, schema -> (field, attribute) -> this.tpl.initKey((Schema)schema, (MField)field, (MAttribute)attribute));
    }

    public static DataEvent create(DataAtom atom, AoSentence sentence) {
        return new DataEvent(atom, sentence);
    }

    public DataEvent init(EventType type) {
        this.io = AoIo.create(type);
        if (null != this.io) {
            this.io.on(this.tpl);
        }
        return this;
    }

    @SafeVarargs
    public final <ID> DataEvent keys(ID ... keys) {
        this.io.keys(keys);
        return this;
    }

    public DataEvent records(Record ... records) {
        this.io.records(records);
        return this;
    }

    public DataEvent uuid() {
        this.io.uuid();
        return this;
    }

    public DataEvent criteria(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public DataEvent inquiry(Inquiry inquiry) {
        this.inquiry = inquiry;
        if (Objects.nonNull(inquiry)) {
            this.criteria = inquiry.getCriteria();
            Set projections = Optional.ofNullable(inquiry.getProjection()).orElse(new HashSet());
            if (!projections.isEmpty()) {
                this.projection.addAll(projections);
            }
        }
        return this;
    }

    public DataEvent stored(List<DataRow> rows) {
        this.io.on(rows);
        return this;
    }

    public DataEvent stored(Long counter) {
        this.counter = counter;
        return this;
    }

    public Long getCounter() {
        return this.counter;
    }

    public DataTpl getTpl() {
        return this.tpl;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public Set<String> getProjection() {
        return this.projection;
    }

    public Pager getPager() {
        if (Objects.nonNull(this.inquiry)) {
            return this.inquiry.getPager();
        }
        return null;
    }

    public Sorter getSorter() {
        if (Objects.nonNull(this.inquiry)) {
            return this.inquiry.getSorter();
        }
        return null;
    }

    public ModelType getType() {
        return this.atom.getModel().getType();
    }

    public DataRow getRow() {
        List<DataRow> rows = this.io.getRows();
        Fn.outWeb((null == rows || rows.isEmpty() ? 1 : 0) != 0, _417DataRowNullException.class, (Object[])new Object[]{this.getClass(), this.atom.identifier()});
        DataRow row = rows.get(0);
        Fn.outWeb((null == row ? 1 : 0) != 0, _417DataRowNullException.class, (Object[])new Object[]{this.getClass(), this.atom.identifier()});
        return row;
    }

    public List<DataRow> getRows() {
        return this.io.getRows();
    }

    public Record getRecord() {
        DataRow row;
        List<DataRow> rows = this.io.getRows();
        Record record = Ao.record(this.atom);
        if (null != rows && !rows.isEmpty() && null != (row = rows.get(0))) {
            record = row.getRecord();
        }
        AoRay<Record> ray = new RaySingle().on(this.tpl);
        return ray.attach(record);
    }

    public Record[] getRecords() {
        List<DataRow> rows = this.getRows();
        Record[] response = rows.stream().map(DataRow::getRecord).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new Record[0]);
        AoRay<Record[]> ray = new RayBatch().on(this.tpl);
        return ray.attach(response);
    }

    public JsonObject getPagination() {
        Record[] records = this.getRecords();
        JsonArray list = new JsonArray();
        Arrays.stream(records).map(Json::toJson).forEach(arg_0 -> ((JsonArray)list).add(arg_0));
        JsonObject pagination = new JsonObject();
        pagination.put("list", list);
        pagination.put("count", Long.valueOf(this.counter));
        return pagination;
    }

    public void failure(WebException ex) {
        this.exception = ex;
    }

    public WebException getError() {
        return this.exception;
    }

    public Boolean succeed() {
        List<DataRow> rows = this.getRows();
        long counter = rows.stream().filter(DataRow::succeed).count();
        return (long)rows.size() == counter && null == this.exception;
    }

    public void consoleAll() {
        Debug.tpl(this.tpl);
        Debug.io(this.io.getRows());
    }
}

