/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import cn.vertxup.atom.domain.tables.pojos.MJoin;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.element.DataKey;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.id.AoId;
import io.vertx.up.annotations.Contract;
import io.vertx.up.commune.ActiveRecord;
import io.vertx.up.commune.Record;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class DataRecord
extends ActiveRecord {
    @Contract
    private transient DataAtom atom;

    public Record createNew() {
        return Ao.record(this.atom);
    }

    public Set<String> joins() {
        return this.atom.getModel().getJoins().stream().map(MJoin::getEntityKey).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<String> declaredFields() {
        return this.atom.attributes();
    }

    public ConcurrentMap<String, Class<?>> types() {
        return this.atom.type();
    }

    public <ID> ID key() {
        return this.id().key((Record)this, this.atom.getModel());
    }

    public String identifier() {
        return Objects.isNull(this.atom) ? super.identifier() : this.atom.identifier();
    }

    public <ID> void key(ID key) {
        this.id().key((Record)this, this.atom.getModel(), key);
    }

    private AoId id() {
        Model model = this.atom.getModel();
        DataKey keyRef = model.getKey();
        return AoId.get(keyRef.getMode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataRecord)) {
            return false;
        }
        DataRecord that = (DataRecord)((Object)o);
        return this.data().equals((Object)that.data()) && this.atom.equals(that.atom);
    }

    public int hashCode() {
        return Objects.hash(this.data(), this.atom);
    }
}

