/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MModel;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.data.Bridge;
import io.vertx.up.commune.element.CParam;
import io.vertx.up.commune.element.Shape;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;

class MetaInfo {
    private final transient Model modelRef;
    private final transient String identifier;
    private final transient Shape shape = Shape.create();

    MetaInfo(Model modelRef) {
        this.modelRef = modelRef;
        this.identifier = modelRef.identifier();
        modelRef.getAttributes().forEach(attr -> {
            Boolean isArray = attr.getIsArray();
            if (Objects.isNull(isArray)) {
                isArray = Boolean.FALSE;
            }
            String name = attr.getName();
            String alias = attr.getAlias();
            if (Ut.notNil((String)name)) {
                if (isArray.booleanValue()) {
                    this.shape.add(name, alias, Bridge.toShape(attr, MAttribute::getSourceConfig));
                } else {
                    this.shape.add(name, alias, this.type(name));
                }
            }
        });
    }

    Model reference() {
        return this.modelRef;
    }

    String identifier() {
        return this.identifier;
    }

    String sigma() {
        return this.sure(MModel::getSigma);
    }

    String language() {
        return this.sure(MModel::getLanguage);
    }

    Set<String> attributes() {
        return this.modelRef.getAttributes().stream().map(MAttribute::getName).filter(Ut::notNil).collect(Collectors.toSet());
    }

    ConcurrentMap<String, String> alias() {
        return this.shape.alias();
    }

    Shape shape() {
        return this.shape;
    }

    CParam diff() {
        return CParam.create(this.modelRef.types());
    }

    CParam diff(Set<String> ignoreSet) {
        return this.diff().ignores(ignoreSet);
    }

    ConcurrentMap<String, Class<?>> type() {
        return this.modelRef.types();
    }

    Class<?> type(String field) {
        return this.modelRef.types().getOrDefault(field, null);
    }

    private <T> T sure(Function<MModel, T> function) {
        MModel model = this.reference().getModel();
        if (Objects.isNull(model)) {
            return null;
        }
        return function.apply(model);
    }
}

