/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.atom.cv.em.AttributeType;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.reference.DataQRule;
import io.vertx.tp.atom.modeling.reference.DataQuote;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class MetaReference {
    private final transient ConcurrentMap<String, DataQuote> references = new ConcurrentHashMap<String, DataQuote>();
    private final transient ConcurrentMap<String, DataQRule> rules = new ConcurrentHashMap<String, DataQRule>();
    private final transient ConcurrentMap<String, Set<String>> ruleDiff = new ConcurrentHashMap<String, Set<String>>();

    MetaReference(Model modelRef) {
        Set<MAttribute> attributes = modelRef.getAttributes();
        attributes.stream().filter(Objects::nonNull).filter(attr -> Objects.nonNull(attr.getSource())).filter(attr -> AttributeType.REFERENCE.name().equals(attr.getType())).forEach(attribute -> {
            String source = attribute.getSource();
            DataQuote reference = (DataQuote)Fn.pool(this.references, (Object)source, () -> DataQuote.create(source));
            reference.add((MAttribute)attribute);
        });
        this.references.values().forEach(source -> this.rules.putAll(source.rules()));
        this.rules.forEach((field, rule) -> {
            Set diffFields = Ut.toSet((JsonArray)rule.getDiff());
            if (!diffFields.isEmpty()) {
                this.ruleDiff.put((String)field, diffFields);
            }
        });
    }

    ConcurrentMap<String, DataQuote> references() {
        return this.references;
    }

    ConcurrentMap<String, DataQRule> rules() {
        return this.rules;
    }

    ConcurrentMap<String, Set<String>> ruleDiff() {
        return this.ruleDiff;
    }
}

