/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.element;

import io.vertx.tp.atom.modeling.element.DataKey;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.modeling.element.Sync;
import io.vertx.tp.atom.refine.Ao;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jooq.Record;

public class DataRow
implements Serializable {
    private final transient ConcurrentMap<String, DataMatrix> matrix = new ConcurrentHashMap<String, DataMatrix>();
    private final transient ConcurrentMap<String, DataMatrix> keys = new ConcurrentHashMap<String, DataMatrix>();
    private final transient ConcurrentMap<String, Boolean> rowResult = new ConcurrentHashMap<String, Boolean>();
    private final transient DataTpl tpl;
    private final transient DataKey key;
    private final transient io.vertx.up.commune.Record record;
    private transient Object id;

    public DataRow(DataTpl tpl) {
        this.tpl = tpl;
        this.record = tpl.createRecord();
        this.key = tpl.createKey();
        this.key.setMatrix(this.keys);
        this.tpl.matrixData().forEach((key, value) -> this.matrix.put((String)key, value.copy()));
        this.tpl.matrixKey().forEach((key, value) -> this.keys.put((String)key, value.copy()));
        this.matrix.keySet().forEach(table -> this.rowResult.put((String)table, Boolean.FALSE));
    }

    public DataRow setData(io.vertx.up.commune.Record record) {
        this.id = record.key();
        record.fields().forEach(attribute -> this.record.set(attribute, record.get(attribute)));
        Ao.connect(this.record, this.matrix);
        return this;
    }

    public ConcurrentMap<String, DataMatrix> matrixKey() {
        return this.keys;
    }

    public ConcurrentMap<String, DataMatrix> matrixData() {
        return this.matrix;
    }

    public DataKey getKey() {
        return this.key;
    }

    public <ID> DataRow setKey(ID id) {
        this.id = id;
        this.record.key(id);
        Ao.connect(this.record, this.keys, this.matrix, this.record.joins());
        return this;
    }

    public Object getId() {
        return this.id;
    }

    public io.vertx.up.commune.Record getRecord() {
        Set primaryKeys = this.matrix.keySet().stream().map(this.matrix::get).flatMap(matrixItem -> matrixItem.getKeys().stream()).collect(Collectors.toSet());
        if (primaryKeys.size() == this.record.size()) {
            return null;
        }
        return this.record;
    }

    public io.vertx.up.commune.Record getRowRecord() {
        return this.record;
    }

    public DataRow success(String table) {
        this.rowResult.put(table, Boolean.TRUE);
        return this;
    }

    public DataRow success(String table, Record record, Set<String> projection) {
        DataMatrix matrix = (DataMatrix)this.matrix.get(table);
        Sync.doData(matrix, this.record, record, projection);
        return this.success(table);
    }

    public boolean succeed() {
        long results = this.rowResult.values().stream().filter(item -> item).count();
        return (long)this.rowResult.keySet().size() == results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataRow)) {
            return false;
        }
        DataRow dataRow = (DataRow)o;
        return this.id.equals(dataRow.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public void appendConsole(StringBuilder source) {
        source.append("------------------------- \u8bb0\u5f55\uff1a").append(this.getId()).append(" -----------------------\n");
        this.keys.forEach((table, matrix) -> {
            DataMatrix data = (DataMatrix)this.matrix.get(table);
            source.append("--------------------- \u6765\u6e90\uff1a").append((String)table).append("\n");
            data.appendData(source, 30);
        });
    }
}

