/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.reference;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonArrayDeserializer;
import com.fasterxml.jackson.databind.JsonArraySerializer;
import com.fasterxml.jackson.databind.JsonObjectDeserializer;
import com.fasterxml.jackson.databind.JsonObjectSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.up.atom.Kv;
import io.vertx.up.commune.Record;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataQRule
implements Serializable {
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private transient JsonObject condition;
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private transient JsonObject conditions;
    @JsonSerialize(using=JsonArraySerializer.class)
    @JsonDeserialize(using=JsonArrayDeserializer.class)
    private transient JsonArray required;
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private transient JsonObject joined;
    @JsonSerialize(using=JsonArraySerializer.class)
    @JsonDeserialize(using=JsonArrayDeserializer.class)
    private transient JsonArray diff;
    @JsonIgnore
    private transient Class<?> type;

    public JsonObject getCondition() {
        return this.condition;
    }

    public void setCondition(JsonObject condition) {
        this.condition = condition;
    }

    public JsonObject getConditions() {
        return this.conditions;
    }

    public void setConditions(JsonObject conditions) {
        this.conditions = conditions;
    }

    public JsonArray getRequired() {
        return this.required;
    }

    public void setRequired(JsonArray required) {
        this.required = required;
    }

    public JsonObject getJoined() {
        return this.joined;
    }

    public void setJoined(JsonObject joined) {
        this.joined = joined;
    }

    public JsonArray getDiff() {
        return this.diff;
    }

    public void setDiff(JsonArray diff) {
        this.diff = diff;
    }

    public Class<?> type() {
        return this.type;
    }

    public DataQRule type(Class<?> type) {
        this.type = type;
        return this;
    }

    public List<Kv<String, String>> joined() {
        ArrayList<Kv<String, String>> joinedKeys = new ArrayList<Kv<String, String>>();
        Ut.itJObject((JsonObject)this.joined, (value, key) -> joinedKeys.add(Kv.create((Object)key, (Object)value)));
        return joinedKeys;
    }

    public JsonObject condition(Record record) {
        JsonObject tpl = new JsonObject();
        this.condition(this.condition).forEach(field -> {
            String target = this.condition.getString(field);
            Object value = record.get(target);
            if (Objects.nonNull(value)) {
                tpl.put(field, value);
            }
        });
        tpl.put("", this.condition.getBoolean("", Boolean.FALSE));
        Ao.infoUca(this.getClass(), "Single condition building: {0}", tpl.encode());
        return tpl;
    }

    public JsonObject condition(Record[] records) {
        JsonObject tpl = new JsonObject();
        this.condition(this.conditions).forEach(field -> {
            String target = this.conditions.getString(field);
            Set values = Arrays.stream(records).map(record -> record.get(target)).filter(Objects::nonNull).collect(Collectors.toSet());
            tpl.put(field, Ut.toJArray(values));
        });
        tpl.put("", this.conditions.getBoolean("", Boolean.FALSE));
        Ao.infoUca(this.getClass(), "Batch condition building: {0}", tpl.encode());
        return tpl;
    }

    private Stream<String> condition(JsonObject condition) {
        return condition.fieldNames().stream().filter(Ut::notNil).filter(field -> Objects.nonNull(condition.getValue(field))).filter(field -> condition.getValue(field) instanceof String);
    }
}

