/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.reference;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.reference.DataQRule;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DataQuote
implements Serializable {
    private final transient String source;
    private final transient ConcurrentMap<String, Class<?>> typeMap = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, JsonObject> sourceConfig = new ConcurrentHashMap<String, JsonObject>();
    private final transient ConcurrentMap<String, JsonObject> sourceReference = new ConcurrentHashMap<String, JsonObject>();
    private final transient ConcurrentMap<String, DataQRule> sourceRule = new ConcurrentHashMap<String, DataQRule>();

    private DataQuote(String source) {
        this.source = source;
    }

    public static DataQuote create(String tableName) {
        return new DataQuote(tableName);
    }

    @Fluent
    public DataQuote add(MAttribute attribute) {
        Boolean isArray = attribute.getIsArray();
        String name = attribute.getName();
        if (Objects.nonNull(isArray) && isArray.booleanValue()) {
            this.typeMap.put(name, JsonArray.class);
        } else {
            this.typeMap.put(name, JsonObject.class);
        }
        if (Objects.nonNull(attribute.getSourceConfig())) {
            JsonObject sourceConfig = Ut.toJObject((String)attribute.getSourceConfig());
            this.sourceConfig.put(name, sourceConfig);
        }
        if (Objects.nonNull(attribute.getSourceReference())) {
            JsonObject sourceReference = Ut.toJObject((String)attribute.getSourceReference());
            this.sourceReference.put(name, sourceReference);
            JsonObject ruleData = Ut.sureJObject((JsonObject)sourceReference.getJsonObject("rule"));
            if (Ut.notNil((JsonObject)ruleData)) {
                DataQRule rule = (DataQRule)Ut.deserialize((JsonObject)ruleData, DataQRule.class);
                this.sourceRule.put(name, rule.type((Class)this.typeMap.get(name)));
            }
        }
        return this;
    }

    public ConcurrentMap<String, DataQRule> rules() {
        return this.sourceRule;
    }

    public Class<?> type(String field) {
        return this.typeMap.getOrDefault(field, null);
    }
}

