/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.data.DataRecord;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.modular.jooq.convert.JsonArraySider;
import io.vertx.tp.modular.jooq.convert.JsonObjectSider;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.up.commune.Record;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Converter;

class AoData {
    private static ConcurrentMap<Class<?>, Converter> CONVERT_MAP = new ConcurrentHashMap<Class<?>, Converter>(){
        {
            this.put(JsonArray.class, Ut.singleton(JsonArraySider.class, (Object[])new Object[0]));
            this.put(JsonObject.class, Ut.singleton(JsonObjectSider.class, (Object[])new Object[0]));
        }
    };

    AoData() {
    }

    static void connect(Record record, ConcurrentMap<String, DataMatrix> dataMatrix) {
        dataMatrix.values().forEach(matrix -> matrix.getAttributes().forEach(attribute -> matrix.set((String)attribute, record.get(attribute))));
    }

    static void connect(Record record, ConcurrentMap<String, DataMatrix> keyMatrix, ConcurrentMap<String, DataMatrix> dataMatrix, Set<String> joins) {
        Object id = record.key();
        keyMatrix.values().forEach(matrix -> matrix.getAttributes().forEach(attribute -> matrix.set((String)attribute, id)));
        dataMatrix.values().forEach(matrix -> matrix.getKeys().stream().filter(attribute -> Objects.nonNull(record.get(attribute))).forEach(attribute -> matrix.set((String)attribute, record.get(attribute))));
        dataMatrix.values().forEach(matrix -> {
            Set<String> attributes = matrix.getAttributes();
            Set<String> keys = matrix.getKeys();
            joins.stream().filter(attributes::contains).filter(attribute -> !keys.contains(attribute)).forEach(joinButNoPrimaryKey -> matrix.set((String)joinButNoPrimaryKey, id));
        });
    }

    static Record record(DataAtom atom) {
        DataRecord record = new DataRecord();
        Ut.contract((Object)((Object)record), DataAtom.class, (Object)atom);
        return record;
    }

    static List<Record> records(DataAtom atom, ExTable table) {
        List records = table.get();
        ArrayList<Record> results = new ArrayList<Record>();
        records.forEach(each -> {
            DataRecord record = new DataRecord();
            Ut.contract((Object)((Object)record), DataAtom.class, (Object)atom);
            JsonObject data = each.toJson();
            record.set(data);
            results.add((Record)record);
        });
        return results;
    }

    static Record[] records(JsonArray data, DataAtom atom) {
        ArrayList recordList = new ArrayList();
        Ut.itJArray((JsonArray)data).map(each -> AoData.record(each, atom)).forEach(recordList::add);
        return recordList.toArray(new Record[0]);
    }

    static Record record(JsonObject data, DataAtom atom) {
        DataRecord record = new DataRecord();
        Ut.contract((Object)((Object)record), DataAtom.class, (Object)atom);
        record.fromJson(data);
        return record;
    }

    static Converter converter(Class<?> type) {
        return CONVERT_MAP.getOrDefault(type, null);
    }
}

