/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.refine;

import cn.vertxup.atom.domain.tables.pojos.MJoin;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.data.DataRecord;
import io.vertx.up.commune.Record;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class AoKey {
    AoKey() {
    }

    static String joinKey(Model model) {
        return model.getJoins().stream().map(MJoin::getEntityKey).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static ConcurrentMap<String, Object> joinKeys(Model model, Record record) {
        Set<MJoin> joins = model.getJoins();
        ConcurrentHashMap<String, Object> keyMap = new ConcurrentHashMap<String, Object>();
        joins.stream().map(MJoin::getEntityKey).filter(Objects::nonNull).filter(attribute -> record.fields().contains(attribute)).forEach(attribute -> keyMap.put((String)attribute, record.get(attribute)));
        return keyMap;
    }

    static <ID> Object toKey(ID id) {
        if (null == id) {
            return null;
        }
        if (id instanceof UUID) {
            return id.toString();
        }
        return id;
    }

    static <ID> ID toKey(JsonObject data, DataAtom atom) {
        Record record = AoKey.toData(data, atom);
        return (ID)record.key();
    }

    static <ID> void toKey(JsonObject data, DataAtom atom, ID defaultKey) {
        if (Objects.nonNull(defaultKey)) {
            Record record = AoKey.toData(data, atom);
            record.key(defaultKey);
            data.mergeIn(record.toJson());
        }
    }

    private static Record toData(JsonObject data, DataAtom atom) {
        DataRecord record = new DataRecord();
        Ut.contract((Object)((Object)record), DataAtom.class, (Object)atom);
        record.set(data);
        return record;
    }
}

