/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.change;

import io.vertx.tp.modular.change.AbstractAdjuster;
import java.math.BigDecimal;
import java.util.Objects;

final class BigDecimalAj
extends AbstractAdjuster {
    public BigDecimalAj(Class<?> type) {
        super(type);
    }

    @Override
    public Object inValue(Object ucmdbInput) {
        String literal = this.literal(ucmdbInput);
        if (Objects.isNull(literal)) {
            return null;
        }
        return Double.parseDouble(literal);
    }

    @Override
    public Object outValue(Object input) {
        if (Objects.isNull(input)) {
            return null;
        }
        if (input instanceof Double) {
            BigDecimal decimal = BigDecimal.valueOf((Double)input);
            return decimal.toPlainString();
        }
        if (input instanceof Integer) {
            int result = (Integer)input;
            BigDecimal decimal = BigDecimal.valueOf(result);
            return decimal.toPlainString();
        }
        if (input instanceof Long) {
            long result = (Long)input;
            BigDecimal decimal = BigDecimal.valueOf(result);
            return decimal.toPlainString();
        }
        BigDecimal decimal = (BigDecimal)input;
        return decimal.toPlainString();
    }
}

