/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.change;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.modular.change.AbstractAdjuster;
import java.util.Objects;

final class BooleanAj
extends AbstractAdjuster {
    public BooleanAj(Class<?> type) {
        super(type);
    }

    @Override
    public Object inValue(Object ucmdbInput) {
        String key;
        String liberal = this.literal(ucmdbInput);
        if (Objects.isNull(liberal)) {
            return Boolean.FALSE;
        }
        JsonObject mapping = this.configIn();
        if (mapping.containsKey(key = liberal.toLowerCase())) {
            return mapping.getBoolean(key);
        }
        return Boolean.FALSE;
    }

    @Override
    public Object outValue(Object input) {
        Boolean bool = Objects.isNull(input) ? Boolean.FALSE : (Boolean)input;
        JsonObject mapping = this.configOut();
        if (mapping.containsKey(bool.toString())) {
            return mapping.getString(bool.toString());
        }
        return bool.toString();
    }

    @Override
    public boolean isSame(Object oldValue, Object newValue) {
        JsonObject mapping = this.configIn();
        return this.isSame(oldValue, newValue, () -> {
            String normNew = newValue.toString().trim();
            if (mapping.containsKey(normNew.toLowerCase())) {
                Boolean newConvert = mapping.getBoolean(normNew.toLowerCase());
                return newConvert.equals(oldValue);
            }
            return oldValue.toString().trim().equalsIgnoreCase(normNew);
        });
    }
}

