/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.dao;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.dao.AoDao;
import io.vertx.tp.modular.dao.internal.Aggregator;
import io.vertx.tp.modular.dao.internal.Listor;
import io.vertx.tp.modular.dao.internal.Partakor;
import io.vertx.tp.modular.dao.internal.Searchor;
import io.vertx.tp.modular.dao.internal.Uniqueor;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.commune.Record;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;

public abstract class AbstractDao
implements AoDao {
    protected final transient AoConnection conn;
    private final transient Partakor partakor = Partakor.create();
    private final transient Uniqueor uniqueor = Uniqueor.create();
    private final transient Listor listor = Listor.create();
    private final transient Searchor searchor = Searchor.create();
    private final transient Aggregator aggregator = Aggregator.create();

    public AbstractDao(AoConnection conn) {
        this.conn = conn;
        ((Partakor)this.partakor.on(this.conn)).on(this.getSentence());
        ((Uniqueor)this.uniqueor.on(this.conn)).on(this.getSentence());
        ((Listor)this.listor.on(this.conn)).on(this.getSentence());
        ((Searchor)this.searchor.on(this.conn)).on(this.getSentence());
        ((Aggregator)this.aggregator.on(this.conn)).on(this.getSentence());
    }

    @Override
    public AoDao mount(DataAtom atom) {
        this.uniqueor.on(atom);
        this.partakor.on(atom);
        this.listor.on(atom);
        this.searchor.on(atom);
        this.aggregator.on(atom);
        return this;
    }

    public abstract AoSentence getSentence();

    @Override
    public int execute(String sql) {
        return this.conn.execute(sql);
    }

    @Override
    public Long count(Criteria criteria) {
        return Ao.doCount(this.getLogger(), this.aggregator::count).apply(criteria);
    }

    @Override
    public Future<Long> countAsync(Criteria criteria) {
        return Ux.future((Object)this.count(criteria));
    }

    @Override
    public Boolean existing(Criteria criteria) {
        return Ao.doBoolean(this.getLogger(), this.aggregator::existing).apply(criteria);
    }

    @Override
    public Future<Boolean> existingAsync(Criteria criteria) {
        return Ux.future((Object)this.existing(criteria));
    }

    @Override
    public Boolean missing(Criteria criteria) {
        return Ao.doBoolean(this.getLogger(), this.aggregator::missing).apply(criteria);
    }

    @Override
    public Future<Boolean> missingAsync(Criteria criteria) {
        return Ux.future((Object)this.missing(criteria));
    }

    @Override
    public Future<Record> insertAsync(Record record) {
        return Ux.future((Object)this.insert(record));
    }

    @Override
    public Record insert(Record record) {
        return Ao.doFluent(this.getLogger(), this.partakor::insert).apply(record);
    }

    @Override
    public Record[] insert(Record ... records) {
        return Ao.doFluent(this.getLogger(), this.partakor::insert).apply(records);
    }

    @Override
    public Future<Record[]> insertAsync(Record ... records) {
        return Ux.future((Object)this.insert(records));
    }

    @Override
    public Future<Record[]> updateAsync(Record ... records) {
        return Ux.future((Object)this.update(records));
    }

    @Override
    public Record[] update(Record ... records) {
        return Ao.doFluent(this.getLogger(), this.partakor::update).apply(records);
    }

    @Override
    public Future<Record> updateAsync(Record record) {
        return Ux.future((Object)this.update(record));
    }

    @Override
    public Record update(Record record) {
        return Ao.doFluent(this.getLogger(), this.partakor::update).apply(record);
    }

    @Override
    public <ID> Record fetchById(ID id) {
        return Ao.doStandard(this.getLogger(), this.uniqueor::fetchById).apply(id);
    }

    @Override
    public <ID> Future<Record> fetchByIdAsync(ID id) {
        return Ux.future((Object)this.fetchById(id));
    }

    @Override
    public <ID> Record[] fetchByIds(ID ... ids) {
        return Ao.doStandard(this.getLogger(), this.listor::fetchByIds).apply(ids);
    }

    @Override
    public <ID> Future<Record[]> fetchByIdsAsync(ID ... ids) {
        return Ux.future((Object)this.fetchByIds(ids));
    }

    @Override
    public Record[] fetchAll() {
        return Ao.doSupplier(this.getLogger(), this.listor::fetchAll).get();
    }

    @Override
    public Future<Record[]> fetchAllAsync() {
        return Ux.future((Object)this.fetchAll());
    }

    @Override
    public Record fetchOne(Criteria criteria) {
        return Ao.doStandard(this.getLogger(), this.uniqueor::fetchOne).apply(criteria);
    }

    @Override
    public JsonObject search(JsonObject query) {
        return Ao.doStandard(this.getLogger(), this.searchor::search).apply(query);
    }

    @Override
    public Record[] fetch(JsonObject criteria) {
        return Ao.doStandard(this.getLogger(), this.searchor::query).apply(criteria);
    }

    @Override
    public Future<Record> fetchOneAsync(Criteria criteria) {
        return Ux.future((Object)this.fetchOne(criteria));
    }

    @Override
    public Future<JsonObject> searchAsync(JsonObject query) {
        return Ux.future((Object)this.search(query));
    }

    @Override
    public Future<Record[]> fetchAsync(JsonObject criteria) {
        return Ux.future((Object)this.fetch(criteria));
    }

    @Override
    public Future<Boolean> deleteAsync(Record record) {
        return Ux.future((Object)this.delete(record));
    }

    @Override
    public boolean delete(Record record) {
        return Ao.doBoolean(this.getLogger(), this.partakor::delete).apply(record);
    }

    @Override
    public Future<Boolean> deleteAsync(Record ... records) {
        return Ux.future((Object)this.delete(records));
    }

    @Override
    public Boolean delete(Record ... records) {
        return Ao.doBoolean(this.getLogger(), this.partakor::delete).apply(records);
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

