/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.dao.internal;

import io.vertx.tp.atom.cv.em.EventType;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.error._417DataAtomNullException;
import io.vertx.tp.modular.dao.internal.AoBinder;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.jooq.JQEngine;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.commune.Record;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import java.util.Arrays;

public abstract class AbstractUtil<T extends AoBinder>
implements AoBinder<T> {
    protected transient AoConnection connection;
    protected transient AoSentence sentence;
    protected transient DataAtom atom;
    protected transient JQEngine jooq;

    @Override
    public T on(AoSentence sentence) {
        this.sentence = sentence;
        this.jooq.bind(sentence);
        return (T)this;
    }

    @Override
    public T on(AoConnection connection) {
        this.connection = connection;
        this.jooq = JQEngine.create(connection.getDSL());
        return (T)this;
    }

    @Override
    public T on(DataAtom atom) {
        this.atom = atom;
        return (T)this;
    }

    private DataEvent event() {
        Fn.outWeb((null == this.atom ? 1 : 0) != 0, _417DataAtomNullException.class, (Object[])new Object[]{this.getClass()});
        return DataEvent.create(this.atom, this.sentence).init(EventType.SINGLE);
    }

    DataEvent events() {
        Fn.outWeb((null == this.atom ? 1 : 0) != 0, _417DataAtomNullException.class, (Object[])new Object[]{this.getClass()});
        return DataEvent.create(this.atom, this.sentence).init(EventType.BATCH);
    }

    DataEvent record(Record record) {
        return this.event().records(record);
    }

    DataEvent records(Record ... records) {
        return this.events().records(records);
    }

    DataEvent idUUID(Record records) {
        return this.event().records(records).uuid();
    }

    DataEvent idUUIDs(Record ... records) {
        return this.events().records(records).uuid();
    }

    <ID> DataEvent idInput(ID ids) {
        return this.event().keys(ids);
    }

    <ID> DataEvent idInputs(ID ... ids) {
        return this.events().keys(ids);
    }

    DataEvent idRecord(Record record) {
        Object[] ids = new Object[]{record.key()};
        return this.event().keys(ids);
    }

    DataEvent idRecords(Record ... records) {
        Object[] ids = Arrays.stream(records).map(rec$ -> ((Record)rec$).key()).toArray();
        return this.events().keys(ids);
    }

    DataEvent irCond(Criteria criteria) {
        return this.event().criteria(criteria);
    }

    DataEvent irInquiry(Inquiry inquiry) {
        return this.event().inquiry(inquiry);
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

