/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.file.excel;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.file.excel.ExIn;
import io.vertx.tp.modular.file.excel.ExOut;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.ExcelInfix;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExAnalyzer {
    private static final ExcelClient CLIENT = ExcelInfix.getClient();
    private final transient ConcurrentMap<String, Set<ExRecord>> recordMap = new ConcurrentHashMap<String, Set<ExRecord>>();
    private transient String appName;

    private ExAnalyzer(String file) {
        this.initMap(CLIENT.ingest(file));
    }

    public static ExAnalyzer create(String file) {
        return new ExAnalyzer(file);
    }

    public ExAnalyzer on(String appName) {
        this.appName = appName;
        return this;
    }

    public Set<Model> build(Set<Schema> schemaSet) {
        HashSet<Model> modelSet = new HashSet<Model>();
        Set<ExRecord> models = this.get("M_MODEL");
        models.forEach(model -> {
            Set<ExRecord> joins = ExIn.join(this.get("M_JOIN"), model);
            Set<ExRecord> attributes = ExIn.searchModel(this.get("M_ATTRIBUTE"), model);
            JsonObject modelJson = ExOut.toModel(model, joins, attributes);
            modelSet.add(Ao.toModel(this.appName, modelJson).onJson(schemaSet));
        });
        return modelSet;
    }

    private Set<ExRecord> get(String key) {
        return this.recordMap.getOrDefault(key, new HashSet());
    }

    private void initMap(final Set<ExTable> tables) {
        ArrayList<String> from = new ArrayList<String>(){
            {
                this.add("M_MODEL");
                this.add("M_ATTRIBUTE");
                this.add("M_JOIN");
            }
        };
        ArrayList<Set<ExRecord>> to = new ArrayList<Set<ExRecord>>(){
            {
                this.add(ExIn.record(tables, "M_MODEL"));
                this.add(ExIn.record(tables, "M_ATTRIBUTE"));
                this.add(ExIn.record(tables, "M_JOIN"));
            }
        };
        this.recordMap.putAll(Ut.elementZip((List)from, (List)to));
    }
}

