/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.modular.jooq.JQQuery;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Batch;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.UpdateSetMoreStep;

class JQUpdate {
    private final transient DSLContext context;
    private final transient JQQuery query;

    JQUpdate(DSLContext context) {
        this.context = context;
        this.query = new JQQuery(context);
    }

    DataEvent update(DataEvent event) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doWrite(this.getClass(), event, (table, matrix) -> {
            UpdateSetMoreStep step = this.stepUpdate((String)table, (DataMatrix)matrix);
            return step.execute();
        }, Ut::isPositive));
    }

    DataEvent updateBatch(DataEvent event) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doWrites(this.getClass(), event, (table, matrixList) -> {
            Batch batch = this.prepareBatch((String)table, (List<DataMatrix>)matrixList);
            return batch.execute();
        }));
    }

    private Batch prepareBatch(String table, List<DataMatrix> matrices) {
        ArrayList batchOps = new ArrayList();
        matrices.stream().map(matrix -> this.stepUpdate(table, (DataMatrix)matrix)).forEach(batchOps::add);
        return this.context.batch(batchOps);
    }

    private UpdateSetMoreStep stepUpdate(String table, DataMatrix matrix) {
        UpdateSetMoreStep steps = (UpdateSetMoreStep)this.context.update(Jq.toTable(table));
        Jq.inArgument(matrix, (arg_0, arg_1) -> ((UpdateSetMoreStep)steps).set(arg_0, arg_1));
        Condition condition = Jq.onKey(matrix);
        steps.where(new Condition[]{condition});
        return steps;
    }
}

