/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.metadata;

import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MKey;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.atom.cv.em.FieldCheckResult;
import io.vertx.tp.atom.cv.em.KeyType;
import io.vertx.tp.atom.cv.sql.SqlStatement;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.tp.modular.sql.SqlDDLBuilder;
import io.vertx.tp.modular.sql.SqlTypeProvider;
import io.vertx.up.commune.config.Database;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractSentence
implements AoSentence,
SqlStatement {
    protected final transient Database database;
    protected final transient SqlTypeProvider typeProvider;
    private final transient SqlDDLBuilder builder = SqlDDLBuilder.create();

    public AbstractSentence(Database database) {
        this.database = database;
        this.typeProvider = SqlTypeProvider.create(database);
    }

    protected abstract ConcurrentMap<String, String> getPrecisionMap();

    protected abstract ConcurrentMap<String, String> getLengthMap();

    @Override
    public String segmentField(MField field) {
        StringBuilder segment = new StringBuilder(this.defineColumn(field));
        if (!field.getIsNullable().booleanValue() || field.getIsPrimary().booleanValue()) {
            segment.append("NOT").append(" ").append("NULL");
        }
        segment.append(" ").append("COMMENT").append(" '");
        if (Ut.notNil((String)field.getComments())) {
            segment.append(field.getComments()).append(",");
        }
        segment.append(field.getName()).append(",").append(field.getColumnName()).append("'");
        return segment.toString();
    }

    @Override
    public String segmentKey(MKey key) {
        StringBuilder segment = new StringBuilder();
        JsonArray columns = new JsonArray(key.getColumns());
        ArrayList columnList = new ArrayList();
        columns.forEach(column -> columnList.add("`" + column + "`"));
        String columnStr = Ut.fromJoin(columnList, (String)",");
        KeyType keyType = (KeyType)Ut.toEnum(KeyType.class, (String)key.getType());
        if (KeyType.PRIMARY == keyType) {
            segment.append(MessageFormat.format("CONSTRAINT {0} PRIMARY KEY ({1})", key.getName(), columnStr));
        } else if (KeyType.UNIQUE == keyType) {
            segment.append(MessageFormat.format("CONSTRAINT {0} UNIQUE ({1})", key.getName(), columnStr));
        }
        return segment.toString();
    }

    @Override
    public String constraintDrop(String tableName, String constraintName) {
        return this.builder.buildDropConstraint(tableName, constraintName);
    }

    @Override
    public String constraintAdd(String tableName, MKey key) {
        return this.builder.buildAddConstraint(tableName, this.segmentKey(key));
    }

    @Override
    public String columnDrop(String tableName, String column) {
        return this.builder.buildDropColumn(tableName, column);
    }

    @Override
    public String columnDropRename(String tableName, String column, String newColumn, String fieldType) {
        return this.builder.buildDropRenameColumn(tableName, column, newColumn);
    }

    @Override
    public String columnAdd(String tableName, MField field) {
        return this.builder.buildAddColumn(tableName, this.segmentField(field));
    }

    @Override
    public String columnAlter(String tableName, MField field) {
        return this.builder.buildAlterColumn(tableName, this.segmentField(field));
    }

    @Override
    public String columnType(MField field) {
        return this.typeProvider.getColumnType(field.getColumnType());
    }

    @Override
    public JsonArray mappingList(String key) {
        return this.typeProvider.getMappingList(key);
    }

    @Override
    public FieldCheckResult checkFieldType(MField field, ConcurrentMap<String, Object> columnDetail) {
        return FieldCheckResult.PASS;
    }

    protected String getType(MField field) {
        String rawType;
        StringBuilder type = new StringBuilder();
        String actualType = rawType = this.typeProvider.getColumnType(field.getColumnType());
        if (rawType.contains("(") && !rawType.contains("(MAX)")) {
            actualType = rawType.split("\\(")[0];
        }
        type.append(this.defineSuffix(field, actualType));
        return type.toString();
    }

    protected String defineSuffix(MField field, String actualType) {
        StringBuilder type = new StringBuilder();
        if (null != field.getPrecision()) {
            if (this.getPrecisionMap().containsKey(actualType)) {
                type.append(MessageFormat.format((String)this.getPrecisionMap().get(actualType), String.valueOf(field.getLength()), field.getPrecision()));
            }
        } else if (this.getLengthMap().containsKey(actualType)) {
            type.append(MessageFormat.format((String)this.getLengthMap().get(actualType), String.valueOf(field.getLength())));
        } else {
            type.append(actualType);
        }
        return type.toString();
    }

    protected String defineColumn(MField field) {
        StringBuilder segment = new StringBuilder();
        String type = this.getType(field);
        segment.append(this.columnDdl(field.getColumnName())).append(" ").append(type).append(" ");
        return segment.toString();
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

