/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.phantom;

import cn.vertxup.atom.domain.tables.daos.MModelDao;
import cn.vertxup.atom.domain.tables.pojos.MModel;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.error._404ModelNotFoundException;
import io.vertx.tp.modular.phantom.AoModeler;
import io.vertx.tp.modular.phantom.AoPerformer;
import io.vertx.tp.modular.phantom.ModelTool;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ModelPerformer
implements AoPerformer {
    private static final ConcurrentMap<String, ModelTool> POOL_TOOL = new ConcurrentHashMap<String, ModelTool>();
    private final transient String namespace;
    private final transient ModelTool tool;

    ModelPerformer(String appName) {
        this.namespace = Model.namespace(appName);
        this.tool = (ModelTool)Fn.pool(POOL_TOOL, (Object)this.namespace, () -> new ModelTool(this.namespace));
    }

    @Override
    public Future<Model> fetchModelAsync(String identifier) {
        return Ux.Jooq.on(MModelDao.class).fetchOneAsync(this.tool.onCriteria(identifier)).compose(this.tool::execute).compose(item -> Ux.future((Object)Model.instance(this.namespace, item)));
    }

    @Override
    public Model fetchModel(String identifier) {
        MModel model = (MModel)Ux.Jooq.on(MModelDao.class).fetchOne(this.tool.onCriteria(identifier));
        Fn.outWeb((null == model ? 1 : 0) != 0, _404ModelNotFoundException.class, (Object[])new Object[]{this.getClass(), this.namespace, identifier});
        JsonObject json = (JsonObject)Ut.serializeJson((Object)model);
        json = AoModeler.init().executor(json);
        json = AoModeler.attribute().executor(json);
        json = AoModeler.join().executor(json);
        json = AoModeler.entity().executor(json);
        json = AoModeler.scatter().executor(json);
        return Model.instance(this.namespace, json);
    }

    @Override
    public Future<Set<Model>> fetchModelsAsync() {
        return Ux.Jooq.on(MModelDao.class).fetchAsync("namespace", (Object)this.namespace).compose(this.tool::startList).compose(this.tool::combine);
    }
}

