/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.ray;

import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.modeling.reference.DataQRule;
import io.vertx.tp.error._501AnonymousAtomException;
import io.vertx.tp.modular.ray.AoRay;
import io.vertx.tp.modular.ray.RaySource;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractRay<T>
implements AoRay<T> {
    protected transient DataTpl tpl;
    protected transient ConcurrentMap<String, RaySource> refer = new ConcurrentHashMap<String, RaySource>();
    protected transient ConcurrentMap<String, DataQRule> referRules = new ConcurrentHashMap<String, DataQRule>();

    @Override
    public AoRay<T> on(DataTpl tpl) {
        this.tpl = tpl;
        DataAtom atom = tpl.atom();
        if (Objects.isNull(atom)) {
            throw new _501AnonymousAtomException(tpl.getClass());
        }
        atom.ref().forEach((atomRef, dataQuote) -> {
            RaySource raySource = RaySource.create(dataQuote, atomRef);
            this.refer.put(atomRef.identifier(), raySource);
        });
        this.referRules.putAll(atom.refRules());
        return this;
    }

    @Override
    public T attach(T input) {
        if (this.refer.isEmpty()) {
            return input;
        }
        return this.doAttach(input);
    }

    public abstract T doAttach(T var1);
}

