/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.ray;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.reference.DataQRule;
import io.vertx.tp.modular.ray.RayRuler;
import io.vertx.up.atom.Kv;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.element.JAmb;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

class RayCombine {
    RayCombine() {
    }

    static Record combine(Record record, ConcurrentMap<String, JAmb> ambMap, ConcurrentMap<String, DataQRule> ruleMap) {
        ambMap.forEach((field, each) -> {
            DataQRule rule = (DataQRule)ruleMap.get(field);
            RayCombine.combine(record, field, each, rule);
        });
        return record;
    }

    static Record[] combine(Record[] records, ConcurrentMap<String, JAmb> ambMap, ConcurrentMap<String, DataQRule> ruleMap) {
        ambMap.forEach((field, each) -> {
            DataQRule rule = (DataQRule)ruleMap.get(field);
            if (Objects.nonNull(rule)) {
                RayCombine.combine(records, field, each, rule);
            }
        });
        return records;
    }

    private static void combine(Record[] records, String field, JAmb amb, DataQRule rule) {
        JAmb normalized;
        List<Kv<String, String>> ruleJoined = rule.joined();
        Boolean single = amb.isSingle();
        if (Objects.nonNull(single) && !single.booleanValue() && Objects.nonNull(normalized = RayRuler.required(amb, rule))) {
            JsonArray source = (JsonArray)normalized.dataT();
            Class<?> returnType = rule.type();
            ConcurrentMap<String, JAmb> grouped = RayRuler.group(source, ruleJoined, returnType);
            Arrays.stream(records).forEach(record -> {
                String joinedKey = RayRuler.joinedKey(record, ruleJoined);
                if (grouped.containsKey(joinedKey)) {
                    JAmb item = (JAmb)grouped.get(joinedKey);
                    RayCombine.combine(record, field, item, rule);
                }
            });
        }
    }

    static void combine(Record record, String field, JAmb amb, DataQRule rule) {
        Boolean single = amb.isSingle();
        if (Objects.nonNull(single)) {
            if (single.booleanValue()) {
                JAmb normalized = RayRuler.required(amb, rule);
                if (Objects.nonNull(normalized)) {
                    JsonObject data = (JsonObject)amb.dataT();
                    record.add(field, (Object)data);
                }
            } else {
                JAmb normalized = RayRuler.required(amb, rule);
                if (Objects.nonNull(normalized)) {
                    JsonArray data = (JsonArray)amb.dataT();
                    record.add(field, (Object)data);
                }
            }
        }
    }
}

