/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.ray;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.reference.DataQRule;
import io.vertx.up.atom.Kv;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.element.JAmb;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class RayRuler {
    RayRuler() {
    }

    static ConcurrentMap<String, JAmb> group(JsonArray source, List<Kv<String, String>> joined, Class<?> type) {
        ConcurrentHashMap<String, JAmb> grouped = new ConcurrentHashMap<String, JAmb>();
        if (JsonObject.class == type) {
            Ut.itJArray((JsonArray)source).forEach(json -> {
                String key = RayRuler.joinedKey(json, joined);
                if (Ut.notNil((String)key)) {
                    grouped.put(key, new JAmb().data(json));
                }
            });
        } else {
            ConcurrentHashMap<String, JsonArray> groupedArray = new ConcurrentHashMap<String, JsonArray>();
            Ut.itJArray((JsonArray)source).forEach(json -> {
                String key = RayRuler.joinedKey(json, joined);
                if (Ut.notNil((String)key)) {
                    JsonArray group = (JsonArray)Fn.pool((ConcurrentMap)groupedArray, (Object)key, JsonArray::new);
                    group.add(json);
                }
            });
            groupedArray.forEach((key, data) -> {
                JAmb amb = new JAmb().data(data);
                grouped.put((String)key, amb);
            });
        }
        return grouped;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static JAmb required(JAmb amb, DataQRule rule) {
        Boolean isSingle = amb.isSingle();
        if (Objects.isNull(isSingle)) {
            return null;
        }
        if (isSingle.booleanValue()) {
            JsonObject data = RayRuler.compress((JsonObject)amb.dataT(), rule);
            if (!Objects.nonNull(data)) return null;
            amb.data(data);
            return amb;
        } else {
            JsonArray dataArray = (JsonArray)amb.dataT();
            JsonArray normalized = new JsonArray();
            Ut.itJArray((JsonArray)dataArray).map(json -> RayRuler.compress(json, rule)).filter(Objects::nonNull).forEach(arg_0 -> ((JsonArray)normalized).add(arg_0));
            amb.data(dataArray);
        }
        return amb;
    }

    private static String joinedKey(JsonObject item, List<Kv<String, String>> joined) {
        StringBuilder key = new StringBuilder();
        joined.forEach(kv -> {
            Object value = item.getValue((String)kv.getKey());
            if (Objects.nonNull(value)) {
                key.append(value);
            }
        });
        return key.toString();
    }

    static String joinedKey(Record record, List<Kv<String, String>> joined) {
        StringBuilder key = new StringBuilder();
        joined.forEach(kv -> {
            Object value = record.get((String)kv.getValue());
            if (Objects.nonNull(value)) {
                key.append(value);
            }
        });
        return key.toString();
    }

    private static JsonObject compress(JsonObject item, DataQRule rule) {
        JsonArray required = rule.getRequired();
        if (Ut.notNil((JsonArray)required)) {
            Set fields = Ut.toSet((JsonArray)required);
            if (RayRuler.isSatisfy(item, fields)) {
                return item;
            }
            return null;
        }
        return item;
    }

    private static boolean isSatisfy(JsonObject item, Set<String> requiredSet) {
        return requiredSet.stream().allMatch(field -> {
            Object value = item.getValue(field);
            if (Objects.nonNull(value)) {
                return Ut.notNil((String)value.toString());
            }
            return false;
        });
    }
}

