/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.ray;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.reference.DataQRule;
import io.vertx.tp.atom.modeling.reference.DataQuote;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.modular.dao.AoDao;
import io.vertx.tp.optic.DS;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.element.JAmb;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class RaySource {
    private final transient DataQuote quote;
    private final transient DataAtom atom;

    private RaySource(DataQuote quote, DataAtom atom) {
        this.quote = quote;
        this.atom = atom;
    }

    static RaySource create(DataQuote quote, DataAtom atom) {
        return new RaySource(quote, atom);
    }

    public ConcurrentMap<String, JAmb> fetchSingle(Record record) {
        return this.fetchData(rule -> rule.condition(record));
    }

    public ConcurrentMap<String, JAmb> fetchBatch(Record[] records) {
        return this.fetchData(rule -> rule.condition(records));
    }

    private ConcurrentMap<String, JAmb> fetchData(Function<DataQRule, JsonObject> supplier) {
        ConcurrentHashMap<String, JAmb> data = new ConcurrentHashMap<String, JAmb>();
        this.quote.rules().forEach((field, rule) -> {
            Class<?> clazz = this.quote.type((String)field);
            JsonObject condition = (JsonObject)supplier.apply((DataQRule)rule);
            JAmb recordReference = this.fetchData(condition, clazz);
            if (Objects.nonNull(recordReference)) {
                data.put((String)field, recordReference);
            }
        });
        return data;
    }

    private JAmb fetchData(JsonObject condition, Class<?> returnType) {
        AoDao dao = this.dao();
        Record[] data = dao.fetch(condition);
        if (JsonObject.class == returnType) {
            if (1 == data.length) {
                Record record = data[0];
                if (Objects.isNull(record)) {
                    return null;
                }
                JsonObject recordData = record.toJson();
                return new JAmb().data(recordData);
            }
            return null;
        }
        JsonArray dataResult = Ut.toJArray((Record[])data);
        return new JAmb().data(dataResult);
    }

    private AoDao dao() {
        return (AoDao)Ke.channelSync(DS.class, () -> null, ds -> {
            DataPool pool = ds.switchDs(this.atom.sigma());
            if (Objects.nonNull(pool)) {
                Database database = pool.getDatabase();
                return Ao.toDao(database, this.atom);
            }
            return null;
        });
    }
}

