/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.sql;

import io.vertx.tp.atom.cv.sql.SqlStatement;
import io.vertx.tp.modular.sql.SqlDDLConstant;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.List;

public final class SqlDDLBuilder
implements SqlStatement {
    private static SqlDDLBuilder INSTANCE;

    private SqlDDLBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlDDLBuilder create() {
        Class<SqlDDLBuilder> clazz = SqlDDLBuilder.class;
        synchronized (SqlDDLBuilder.class) {
            if (null == INSTANCE) {
                INSTANCE = new SqlDDLBuilder();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public String buildCreateTable(String tableName, List<String> lines) {
        return MessageFormat.format("CREATE TABLE {0} ( {1} );", tableName, Ut.fromJoin(lines, (String)","));
    }

    public String buildDropTable(String table) {
        return MessageFormat.format("DROP TABLE {0};", table);
    }

    public String buildRenameTable(String table) {
        return MessageFormat.format("ALTER TABLE {0} RENAME TO {1};", table, SqlDDLConstant.combineNewName(table));
    }

    public String buildDropColumn(String table, String column) {
        return MessageFormat.format("ALTER TABLE {0} DROP COLUMN {1};", table, column);
    }

    public String buildDropRenameColumn(String table, String column, String newColumn) {
        return MessageFormat.format("ALTER TABLE {0} RENAME COLUMN {1} TO {2};", table, column, newColumn);
    }

    public String buildAlterColumn(String table, String colLine) {
        return MessageFormat.format("ALTER TABLE {0} ALTER COLUMN {1};", table, colLine);
    }

    public String buildAddColumn(String table, String colLine) {
        return MessageFormat.format("ALTER TABLE {0} ADD {1};", table, colLine);
    }

    public String buildAddConstraint(String table, String csLine) {
        return MessageFormat.format("ALTER TABLE {0} ADD {1};", table, csLine);
    }

    public String buildDropConstraint(String table, String constraint) {
        return MessageFormat.format("ALTER TABLE {0} DROP CONSTRAINT {1};", table, constraint);
    }

    public String buildNullSQL(String table, String column) {
        return MessageFormat.format("SELECT COUNT(*) FROM {0} WHERE {1} IS NULL", table, column);
    }

    public String buildUniqueSQL(String table, String column) {
        return MessageFormat.format("SELECT COUNT(DISTINCT {1}) FROM {0} WHERE {1} IN (SELECT {1} FROM {0} GROUP BY {1} HAVING COUNT({1}) > 1)", table, column);
    }

    public String buildRowsSQL(String table) {
        return MessageFormat.format("SELECT COUNT(*) FROM {0}", table);
    }
}

