/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.sql;

import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MKey;
import io.vertx.tp.atom.cv.em.FieldCheckResult;
import io.vertx.tp.atom.cv.em.KeyType;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.error._500NullableAddException;
import io.vertx.tp.error._500NullableAlterException;
import io.vertx.tp.error._500TypeAlterException;
import io.vertx.tp.error._501AoReflectorNullException;
import io.vertx.tp.error._501AoSentenceNullException;
import io.vertx.tp.modular.metadata.AoReflector;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.tp.modular.metadata.FieldComparator;
import io.vertx.tp.modular.sql.SqlDDLConstant;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class SqlDDLProvider {
    private static SqlDDLProvider INSTANCE;
    private transient AoSentence sentence;
    private transient AoReflector reflector;

    private SqlDDLProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlDDLProvider create() {
        Class<SqlDDLProvider> clazz = SqlDDLProvider.class;
        synchronized (SqlDDLProvider.class) {
            if (null == INSTANCE) {
                INSTANCE = new SqlDDLProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public SqlDDLProvider on(AoSentence sentence) {
        this.sentence = sentence;
        return this;
    }

    public SqlDDLProvider on(AoReflector reflector) {
        this.reflector = reflector;
        return this;
    }

    public List<String> prepareCreateLines(Schema schema) {
        Fn.outWeb((null == this.sentence ? 1 : 0) != 0, _501AoSentenceNullException.class, (Object[])new Object[]{this.getClass()});
        ArrayList<String> lines = new ArrayList<String>();
        TreeSet<MField> fields = new TreeSet<MField>(new FieldComparator());
        fields.addAll(Arrays.asList(schema.getFields()));
        fields.forEach(field -> this.addLine(lines, this.sentence.segmentField((MField)field)));
        for (MKey key : schema.getKeys()) {
            this.addLine(lines, this.sentence.segmentKey(key));
        }
        return lines;
    }

    public List<String> prepareAlterLines(Schema schema) {
        Fn.outWeb((null == this.sentence ? 1 : 0) != 0, _501AoSentenceNullException.class, (Object[])new Object[]{this.getClass()});
        Fn.outWeb((null == this.reflector ? 1 : 0) != 0, _501AoReflectorNullException.class, (Object[])new Object[]{this.getClass()});
        ArrayList<String> lines = new ArrayList<String>(this.prepareDropConstraints(schema));
        ConcurrentMap<ChangeFlag, Collection<String>> statusMap = this.getColumnStatus(schema);
        lines.addAll(this.prepareDropRenameColumns(schema, (Collection)statusMap.get(ChangeFlag.DELETE)));
        lines.addAll(this.prepareAddColumns(schema, (Collection)statusMap.get(ChangeFlag.ADD)));
        lines.addAll(this.prepareAlterColumns(schema, (Collection)statusMap.get(ChangeFlag.UPDATE)));
        lines.addAll(this.prepareAddConstraints(schema));
        return lines;
    }

    private List<String> prepareDropColumns(Schema schema, Collection<String> columns) {
        String table = schema.getTable();
        ArrayList<String> segments = new ArrayList<String>();
        columns.forEach(column -> this.addLine(segments, this.sentence.columnDrop(table, (String)column)));
        return segments;
    }

    private List<String> prepareDropRenameColumns(Schema schema, Collection<String> columns) {
        String table = schema.getTable();
        ArrayList<String> segments = new ArrayList<String>();
        List<ConcurrentMap<String, Object>> columnDetailList = this.reflector.getColumnDetail(table);
        columns.stream().filter(column -> !column.endsWith(SqlDDLConstant.getDeleteFieldFlag())).forEach(column -> {
            ConcurrentMap<String, Object> columnDetail = this.reflector.getColumnDetails((String)column, columnDetailList);
            String fieldType = this.reflector.getFieldType(columnDetail);
            this.addLine(segments, this.sentence.columnDropRename(table, (String)column, SqlDDLConstant.combineNewName(column), fieldType));
        });
        return segments;
    }

    private List<String> prepareAddColumns(Schema schema, Collection<String> columns) {
        String table = schema.getTable();
        ArrayList<String> segments = new ArrayList<String>();
        long rows = this.reflector.getTotalRows(table);
        columns.forEach(column -> {
            MField field = schema.getFieldByColumn((String)column);
            Fn.outWeb((0L < rows && field.getIsNullable() == false ? 1 : 0) != 0, _500NullableAddException.class, (Object[])new Object[]{this.getClass(), table, column});
            String sql = this.sentence.columnAdd(table, field);
            this.addLine(segments, sql);
        });
        return segments;
    }

    private List<String> prepareAlterColumns(Schema schema, Collection<String> columns) {
        String table = schema.getTable();
        ArrayList<String> segments = new ArrayList<String>();
        long rows = this.reflector.getTotalRows(table);
        List<ConcurrentMap<String, Object>> columnDetailList = this.reflector.getColumnDetail(table);
        columns.forEach(column -> {
            ConcurrentMap<String, Object> columnDetail;
            MField field = schema.getFieldByColumn((String)column);
            FieldCheckResult checkResult = this.sentence.checkFieldType(field, columnDetail = this.reflector.getColumnDetails((String)column, columnDetailList));
            if (checkResult != FieldCheckResult.SKIP) {
                if (checkResult == FieldCheckResult.FAILED) {
                    Fn.outWeb((boolean)true, _500TypeAlterException.class, (Object[])new Object[]{this.getClass(), table, column});
                }
                if (0L < rows) {
                    long nullRows = this.reflector.getNullRows(table, this.sentence.columnDdl((String)column));
                    Fn.outWeb((0L < nullRows && field.getIsNullable() == false ? 1 : 0) != 0, _500NullableAlterException.class, (Object[])new Object[]{this.getClass(), table, column});
                }
                String sql = this.sentence.columnAlter(table, field);
                this.addLine(segments, sql);
            }
        });
        return segments;
    }

    private ConcurrentMap<ChangeFlag, Collection<String>> getColumnStatus(Schema schema) {
        HashSet oldColumns = new HashSet(this.reflector.getColumns(schema.getTable()));
        Set<String> newColumns = schema.getColumnNames();
        ConcurrentHashMap<ChangeFlag, Collection<String>> statusMap = new ConcurrentHashMap<ChangeFlag, Collection<String>>();
        statusMap.put(ChangeFlag.ADD, Ut.diff(newColumns, oldColumns));
        statusMap.put(ChangeFlag.DELETE, Ut.diff(oldColumns, newColumns));
        statusMap.put(ChangeFlag.UPDATE, Ut.intersect(oldColumns, newColumns));
        return statusMap;
    }

    private List<String> prepareDropConstraints(Schema schema) {
        String table = schema.getTable();
        ConcurrentMap<String, KeyType> constraints = this.reflector.getConstraints(table);
        ArrayList<String> segments = new ArrayList<String>();
        constraints.forEach((name, type) -> this.addLine(segments, this.sentence.constraintDrop(table, (String)name)));
        return segments;
    }

    private List<String> prepareAddConstraints(Schema schema) {
        String table = schema.getTable();
        ArrayList<String> segments = new ArrayList<String>();
        for (MKey key : schema.getKeys()) {
            this.addLine(segments, this.sentence.constraintAdd(table, key));
        }
        return segments;
    }

    private void addLine(List<String> sqls, String line) {
        if (Ut.notNil((String)line)) {
            sqls.add(line);
        }
    }
}

