/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.modeling;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MJoin;
import cn.vertxup.atom.domain.tables.pojos.MModel;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.cv.em.AttributeType;
import io.vertx.tp.atom.cv.em.ModelType;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.element.DataKey;
import io.vertx.tp.modular.apply.AoDefault;
import io.vertx.tp.optic.modeling.Bridge;
import io.vertx.tp.optic.modeling.JsonSchema;
import io.vertx.up.commune.Json;
import io.vertx.up.commune.rule.RuleUnique;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JsonModel
implements Model {
    private final transient Set<Schema> schemata = new HashSet<Schema>();
    private final transient Set<MJoin> joins = new HashSet<MJoin>();
    private final transient ConcurrentMap<String, Class<?>> attributeTypes = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, MAttribute> attributes = new ConcurrentHashMap<String, MAttribute>();
    private final transient String namespace;
    private transient MModel model;
    private transient DataKey key;
    private transient String identifier;
    private transient String jsonFile;
    private transient RuleUnique unique;

    public JsonModel(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public MModel getModel() {
        return this.model;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Schema getSchema(String identifier) {
        return Ut.isNil((String)identifier) ? null : (Schema)this.schemata.stream().filter(schema -> identifier.equals(schema.identifier())).findFirst().orElse(null);
    }

    @Override
    public ConcurrentMap<String, Class<?>> types() {
        if (this.attributeTypes.isEmpty()) {
            this.getAttributes().forEach(attribute -> {
                AttributeType type = (AttributeType)Ut.toEnum(attribute::getType, AttributeType.class, (Enum)AttributeType.INTERNAL);
                if (AttributeType.INTERNAL == type) {
                    Schema schema = this.getSchema(attribute.getSource());
                    MField field = schema.getField(attribute.getSourceField());
                    if (Objects.nonNull(field)) {
                        this.attributeTypes.put(attribute.getName(), Ut.clazz((String)field.getType()));
                    }
                } else if (AttributeType.REFERENCE == type) {
                    if (attribute.getIsArray().booleanValue()) {
                        this.attributeTypes.put(attribute.getName(), JsonArray.class);
                    } else {
                        this.attributeTypes.put(attribute.getName(), JsonObject.class);
                    }
                }
            });
        }
        return this.attributeTypes;
    }

    @Override
    public String file() {
        return this.jsonFile;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public Set<Schema> getSchemata() {
        return this.schemata;
    }

    @Override
    public DataKey getKey() {
        return this.key;
    }

    @Override
    public void setKey(DataKey key) {
        this.key = key;
    }

    @Override
    public ModelType getType() {
        String typeStr = this.model.getType();
        ModelType type = (ModelType)Ut.toEnum(ModelType.class, (String)typeStr);
        return null == type ? ModelType.DIRECT : type;
    }

    @Override
    public Set<MAttribute> getAttributes() {
        return new HashSet<MAttribute>(this.attributes.values());
    }

    @Override
    public MAttribute getAttribute(String attributeName) {
        return (MAttribute)this.attributes.get(attributeName);
    }

    @Override
    public Model onJson(Set<Schema> schemas) {
        if (!this.joins.isEmpty()) {
            Bridge.connect(this, schemas, found -> Bridge.connect((Model)this, found));
        }
        return this;
    }

    @Override
    public Set<MJoin> getJoins() {
        return this.joins;
    }

    @Override
    public void setRelation(String key) {
        this.model.setKey(key);
        this.attributes.values().forEach(attribute -> attribute.setModelId(key));
    }

    @Override
    public void onDatabase(Set<Schema> schemas) {
        Bridge.connect((Model)this, schemas);
    }

    public void fromFile(String file) {
        this.jsonFile = file;
        JsonObject data = Ut.ioJObject((String)this.jsonFile);
        this.fromJson(data);
    }

    @Override
    public RuleUnique getUnique() {
        String content;
        if (Objects.isNull(this.unique) && Ut.notNil((String)(content = this.model.getRuleUnique()))) {
            this.unique = (RuleUnique)Ut.deserialize((String)content, RuleUnique.class);
        }
        return this.unique;
    }

    public void fromJson(JsonObject json) {
        this.attributes.clear();
        this.joins.clear();
        this.schemata.clear();
        JsonObject model = json.getJsonObject("model");
        AoDefault.model().applyJson(model);
        Object uniqueRef = model.getValue("ruleUnique");
        if (uniqueRef instanceof JsonObject) {
            JsonObject content = (JsonObject)uniqueRef;
            this.unique = (RuleUnique)Ut.deserialize((JsonObject)content, RuleUnique.class);
            model.put("ruleUnique", content.encode());
        }
        this.model = (MModel)Ut.deserialize((JsonObject)model, MModel.class);
        this.model.setNamespace(this.namespace);
        this.identifier = this.model.getIdentifier();
        JsonArray attributes = json.getJsonArray("attributes");
        Ut.itJArray((JsonArray)attributes, (attribute, index) -> {
            AoDefault.attribute().mount(this.model).applyJson((JsonObject)attribute);
            MAttribute attributeObj = (MAttribute)Ut.deserialize((JsonObject)attribute, MAttribute.class);
            if (Ut.notNil((String)attributeObj.getName())) {
                this.attributes.put(attributeObj.getName(), attributeObj);
            }
        });
        JsonArray joins = json.getJsonArray("joins");
        Ut.itJArray((JsonArray)joins, (join, index) -> {
            AoDefault.join().mount(this.model).applyJson((JsonObject)join);
            MJoin joinObj = (MJoin)Ut.deserialize((JsonObject)join, MJoin.class);
            this.joins.add(joinObj);
        });
        JsonArray schemata = json.getJsonArray("schema");
        if (null != schemata) {
            Ut.itJArray((JsonArray)schemata, (schema, index) -> {
                JsonSchema schemaObj = new JsonSchema(this.namespace);
                schemaObj.fromJson((JsonObject)schema);
                this.schemata.add(schemaObj);
            });
            Bridge.connect((Model)this, this.namespace + "-" + this.identifier);
        }
    }

    public JsonObject toJson() {
        JsonObject content = new JsonObject();
        JsonObject model = (JsonObject)Ut.serializeJson((Object)this.model);
        Object uniqueRef = model.getValue("ruleUnique");
        if (uniqueRef instanceof String) {
            model.put("ruleUnique", new JsonObject((String)uniqueRef));
        }
        content.put("model", model);
        JsonArray attributes = (JsonArray)Ut.serializeJson(this.attributes.values());
        content.put("attributes", attributes);
        JsonArray joins = (JsonArray)Ut.serializeJson(this.joins);
        content.put("joins", joins);
        JsonArray schemata = new JsonArray();
        this.schemata.stream().map(Json::toJson).forEach(arg_0 -> ((JsonArray)schemata).add(arg_0));
        content.put("schema", schemata);
        return content;
    }

    public String toString() {
        StringBuilder content = new StringBuilder();
        content.append("-- Model Begin ------------------------------");
        content.append("\nfile = ").append(this.jsonFile);
        content.append("\nidentifier = ").append(this.identifier);
        content.append("\nnamespace = ").append(this.namespace);
        content.append("\n\t").append(this.model.toString());
        content.append("\nattributes :");
        this.attributes.forEach((k, v) -> content.append("\n\t").append((String)k).append(" = ").append(v.toString()));
        content.append("\nschemas : [");
        this.schemata.forEach(schema -> content.append("\n").append(schema.toString()));
        content.append("\n]\njoins :");
        this.joins.forEach(item -> content.append("\n\t").append(this.identifier).append("=").append(item.getEntity()).append(",").append(item.getEntityKey()));
        content.append("\n-- Model End --------------------------------\n");
        return content.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonModel)) {
            return false;
        }
        JsonModel that = (JsonModel)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.model.getNamespace(), that.model.getNamespace());
    }

    public int hashCode() {
        return Objects.hash(this.model.getNamespace(), this.identifier);
    }
}

