/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.reference;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.reference.RDao;
import io.vertx.up.atom.Kv;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RQuery
implements Serializable {
    private final transient String name;
    private final transient String sourceField;
    private final List<Kv<String, String>> joined = new ArrayList<Kv<String, String>>();
    private transient RDao daoRef;

    public RQuery(String name, String sourceField) {
        this.name = name;
        this.sourceField = sourceField;
    }

    public RQuery bind(RDao dao) {
        this.daoRef = dao;
        return this;
    }

    public RQuery bind(List<Kv<String, String>> result) {
        this.joined.addAll(result);
        return this;
    }

    public JsonArray fetchBy(Object value) {
        JsonObject condition = new JsonObject();
        if (value instanceof JsonArray) {
            condition.put(this.sourceField + ",i", value);
        } else {
            condition.put(this.sourceField, value);
        }
        condition.put("", Boolean.TRUE);
        return this.daoRef.fetchBy(condition);
    }

    public ConcurrentMap<String, JsonArray> fetchQuery(JsonArray data) {
        ConcurrentHashMap<String, JsonArray> query = new ConcurrentHashMap<String, JsonArray>();
        this.joined.forEach(kv -> {
            String name = (String)kv.getValue();
            String extract = (String)kv.getKey();
            JsonArray compress = Ut.toJArray((Set)Ut.mapString((JsonArray)data, (String)extract));
            query.put(name, compress);
        });
        return query;
    }
}

