/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.reference;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.config.AoRule;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

final class RRuler {
    private RRuler() {
    }

    public static JsonArray required(JsonArray source, AoRule rule) {
        return RRuler.rulerAnd(source, rule.getRequired(), value -> Ut.notNil((String)value.toString()));
    }

    public static JsonArray duplicated(JsonArray source, AoRule rule) {
        HashSet added = new HashSet();
        return RRuler.ruler(source, rule.getUnique(), json -> {
            JsonObject uniqueJson = Ut.elementSubset((JsonObject)json, rule.getUnique());
            if (added.contains(uniqueJson)) {
                return false;
            }
            added.add(uniqueJson);
            return true;
        });
    }

    private static JsonArray rulerAnd(JsonArray source, Set<String> fieldSet, Predicate<Object> fnFilter) {
        return RRuler.ruler(source, fieldSet, json -> fieldSet.stream().allMatch(field -> {
            Object value = json.getValue(field);
            if (Objects.nonNull(value)) {
                return fnFilter.test(value);
            }
            return false;
        }));
    }

    private static JsonArray rulerOr(JsonArray source, Set<String> fieldSet, Predicate<Object> fnFilter) {
        return RRuler.ruler(source, fieldSet, json -> fieldSet.stream().anyMatch(field -> {
            Object value = json.getValue(field);
            if (Objects.nonNull(value)) {
                return fnFilter.test(value);
            }
            return false;
        }));
    }

    private static JsonArray ruler(JsonArray source, Set<String> fieldSet, Predicate<JsonObject> fnFilter) {
        if (fieldSet.isEmpty()) {
            return source;
        }
        JsonArray processed = new JsonArray();
        Ut.itJArray((JsonArray)source).filter(fnFilter).forEach(arg_0 -> ((JsonArray)processed).add(arg_0));
        return processed;
    }
}

