/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.up.atom.Kv;
import io.vertx.up.atom.record.Apt;
import io.vertx.up.commune.compare.Vs;
import io.vertx.up.commune.rule.RuleUnique;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

class AoCompare {
    private AoCompare() {
    }

    static <T> ConcurrentMap<ChangeFlag, List<T>> initMList() {
        return new ConcurrentHashMap<ChangeFlag, List<T>>(){
            {
                this.put(ChangeFlag.DELETE, new ArrayList());
                this.put(ChangeFlag.ADD, new ArrayList());
                this.put(ChangeFlag.UPDATE, new ArrayList());
            }
        };
    }

    static <T> ConcurrentMap<ChangeFlag, Queue<T>> initMQueue() {
        return new ConcurrentHashMap<ChangeFlag, Queue<T>>(){
            {
                this.put(ChangeFlag.DELETE, new ConcurrentLinkedQueue());
                this.put(ChangeFlag.ADD, new ConcurrentLinkedQueue());
                this.put(ChangeFlag.UPDATE, new ConcurrentLinkedQueue());
            }
        };
    }

    static ConcurrentMap<ChangeFlag, JsonArray> initMArray() {
        return new ConcurrentHashMap<ChangeFlag, JsonArray>(){
            {
                this.put(ChangeFlag.DELETE, new JsonArray());
                this.put(ChangeFlag.ADD, new JsonArray());
                this.put(ChangeFlag.UPDATE, new JsonArray());
            }
        };
    }

    static ConcurrentMap<ChangeFlag, JsonArray> diffPure(JsonArray queueO, JsonArray queueN, DataAtom atom, Set<String> ignoreSet) {
        RuleUnique rules = atom.ruleSmart();
        Ao.infoUca(AoCompare.class, "\uff08Pure\uff09\u5bf9\u6bd4\u7528\u6807\u8bc6\u89c4\u5219\uff1a\n{0}", rules.toString());
        final JsonArray queueA = new JsonArray();
        JsonArray queueUTemp = new JsonArray();
        final JsonArray queueD = new JsonArray();
        Ut.itJArray((JsonArray)queueO).forEach(recordO -> {
            JsonObject found = Ux.ruleAny((Collection)rules.rulePure(), (JsonArray)queueN, (JsonObject)recordO);
            if (Objects.isNull(found)) {
                queueD.add(Ux.ruleTwins((JsonObject)recordO, null));
            } else {
                queueUTemp.add(found);
            }
        });
        Ut.itJArray((JsonArray)queueN).forEach(recordN -> {
            JsonObject found = Ux.ruleAny((Collection)rules.rulePure(), (JsonArray)queueO, (JsonObject)recordN);
            if (Objects.isNull(found)) {
                queueA.add(Ux.ruleTwins(null, (JsonObject)recordN));
            }
        });
        final JsonArray queueU = AoCompare.updateQueue(queueUTemp, atom, ignoreSet);
        return new ConcurrentHashMap<ChangeFlag, JsonArray>(){
            {
                this.put(ChangeFlag.ADD, queueA);
                this.put(ChangeFlag.DELETE, queueD);
                this.put(ChangeFlag.UPDATE, queueU);
            }
        };
    }

    static JsonObject diffPure(JsonObject recordO, JsonObject recordN, DataAtom atom, Set<String> ignoreSet) {
        JsonArray queueN = new JsonArray().add(recordN);
        JsonArray queueO = new JsonArray().add(recordO);
        ConcurrentMap<ChangeFlag, JsonArray> processed = AoCompare.diffPure(queueO, queueN, atom, ignoreSet);
        Kv<ChangeFlag, JsonObject> changed = AoCompare.updateKv(processed);
        ChangeFlag flag = (ChangeFlag)changed.getKey();
        Ao.infoUca(AoCompare.class, "\uff08Pure\uff09\u8ba1\u7b97\u53d8\u66f4\u7ed3\u679c\uff1a{0} = {1}", flag, changed.getValue());
        if (ChangeFlag.UPDATE == flag) {
            return recordN;
        }
        return null;
    }

    static Apt diffPure(Apt apt, DataAtom atom, Set<String> ignoreSet) {
        JsonArray queueO = (JsonArray)apt.dataO();
        JsonArray queueN = (JsonArray)apt.dataN();
        Ao.infoUca(AoCompare.class, "\uff08Pure\uff09\u65b0\u65e7\u6570\u91cf\uff1a\uff08{2} vs {3}\uff09\uff0c\u65b0\u6570\u636e\uff1a{1}, \u65e7\u6570\u636e\uff1a{0}", queueO.encode(), queueN.encode(), String.valueOf(queueN.size()), String.valueOf(queueO.size()));
        ConcurrentMap<ChangeFlag, JsonArray> calculated = AoCompare.diffPure(queueO, queueN, atom, ignoreSet);
        return apt.compared(calculated);
    }

    static ConcurrentMap<ChangeFlag, JsonArray> diffPull(JsonArray queueOld, JsonArray queueNew, DataAtom atom, Set<String> ignoreSet) {
        RuleUnique rules = atom.ruleSmart();
        Ao.infoDiff(AoCompare.class, "\uff08Pull\uff09\u5bf9\u6bd4\u7528\u6807\u8bc6\u89c4\u5219\uff1a\n{0}", rules.toString());
        final JsonArray queueA = new JsonArray();
        JsonArray queueUTemp = new JsonArray();
        final JsonArray queueD = new JsonArray();
        Ut.itJArray((JsonArray)queueOld).forEach(recordO -> {
            JsonObject twinO = Ux.ruleAll((Collection)rules.rulePush(), (JsonObject)recordO);
            if (Objects.isNull(twinO)) {
                JsonObject draft = Ux.ruleAny((Collection)rules.rulePure(), (JsonArray)queueNew, (JsonObject)recordO);
                if (Objects.nonNull(draft)) {
                    queueUTemp.add(draft);
                } else {
                    Ao.infoDiff(AoCompare.class, "\u65e7\u6570\u636e\u4e0d\u6ee1\u8db3\u63a8\u9001\u89c4\u5219\uff0c\u5e76\u4e14\u65e0\u6cd5\u5728\u65b0\u961f\u5217\u4e2d\u627e\u5230\uff01{0}", recordO.encode());
                }
            } else {
                JsonObject branch = Ux.ruleAll((Collection)rules.rulePure(), (JsonObject)recordO);
                if (Objects.isNull(branch)) {
                    JsonObject found = Ux.ruleAny((Collection)rules.rulePush(), (JsonArray)queueNew, (JsonObject)recordO);
                    if (Objects.nonNull(found)) {
                        JsonObject foundAny = Ux.ruleAny(new HashSet(rules.rulePush()), (JsonArray)queueNew, (JsonObject)recordO);
                        if (Objects.isNull(foundAny)) {
                            queueUTemp.add(found);
                        } else {
                            Ao.infoDiff(AoCompare.class, "\u7b2c\u4e09\u65b9\u63d0\u4f9b\u4e86 code\uff0c\u6570\u636e\u5f02\u5e38\uff1a{0}", recordO.encode());
                        }
                    }
                } else {
                    JsonObject foundStrong = Ux.ruleAny((Collection)rules.getStrong(), (JsonArray)queueNew, (JsonObject)recordO);
                    if (Objects.isNull(foundStrong)) {
                        JsonObject foundWeak = Ux.ruleAny((Collection)rules.getWeak(), (JsonArray)queueNew, (JsonObject)recordO);
                        if (Objects.isNull(foundWeak)) {
                            queueD.add(Ux.ruleTwins((JsonObject)recordO, null));
                        } else {
                            JsonObject newRef = foundWeak.getJsonObject("__NEW__");
                            JsonObject oldRef = foundWeak.getJsonObject("__OLD__");
                            rules.getStrong().forEach(rule -> rule.getFields().forEach(field -> {
                                Object oldV = oldRef.getValue(field);
                                Object newV = newRef.getValue(field);
                                if (Objects.nonNull(oldV) || Objects.nonNull(newV)) {
                                    newRef.put(field, oldV);
                                }
                            }));
                            queueUTemp.add(foundWeak);
                        }
                    } else {
                        queueUTemp.add(foundStrong);
                    }
                }
            }
        });
        Ut.itJArray((JsonArray)queueNew).map(recordN -> {
            JsonObject processed = Ux.ruleAny((Collection)rules.rulePure(), (JsonArray)queueOld, (JsonObject)recordN);
            if (Objects.isNull(processed)) {
                return Ux.ruleTwins(null, (JsonObject)recordN);
            }
            JsonObject weakFound = Ux.ruleAny((Collection)rules.getWeak(), (JsonArray)queueOld, (JsonObject)recordN);
            if (Objects.isNull(weakFound)) {
                return null;
            }
            JsonObject revert = new JsonObject();
            revert.put("__NEW__", weakFound.getValue("__OLD__"));
            revert.put("__OLD__", weakFound.getValue("__NEW__"));
            if (queueD.contains((Object)revert)) {
                revert.remove("__OLD__");
                return revert;
            }
            return null;
        }).filter(Objects::nonNull).forEach(arg_0 -> ((JsonArray)queueA).add(arg_0));
        final JsonArray queueU = AoCompare.updateQueue(queueUTemp, atom, ignoreSet);
        return new ConcurrentHashMap<ChangeFlag, JsonArray>(){
            {
                this.put(ChangeFlag.ADD, queueA);
                this.put(ChangeFlag.DELETE, queueD);
                this.put(ChangeFlag.UPDATE, queueU);
            }
        };
    }

    static JsonObject diffPull(JsonObject recordO, JsonObject recordN, DataAtom atom, Set<String> ignoreSet) {
        JsonArray queueN = new JsonArray().add(recordN);
        JsonArray queueO = new JsonArray().add(recordO);
        ConcurrentMap<ChangeFlag, JsonArray> processed = AoCompare.diffPull(queueO, queueN, atom, ignoreSet);
        Kv<ChangeFlag, JsonObject> changed = AoCompare.updateKv(processed);
        ChangeFlag flag = (ChangeFlag)changed.getKey();
        Ao.infoUca(AoCompare.class, "\uff08Pull\uff09\u8ba1\u7b97\u53d8\u66f4\u7ed3\u679c\uff1a{0} = {1}", flag, changed.getValue());
        if (ChangeFlag.UPDATE == flag) {
            return recordN;
        }
        return null;
    }

    static Apt diffPull(Apt apt, DataAtom atom, Set<String> ignoreSet) {
        JsonArray queueO = (JsonArray)apt.dataO();
        JsonArray queueN = (JsonArray)apt.dataN();
        Ao.infoUca(AoCompare.class, "\uff08Pull\uff09\u65b0\u65e7\u6570\u91cf\uff1a\uff08{2} vs {3}\uff09\uff0c\u65b0\u6570\u636e\uff1a{1}, \u65e7\u6570\u636e\uff1a{0}", queueO.encode(), queueN.encode(), String.valueOf(queueN.size()), String.valueOf(queueO.size()));
        ConcurrentMap<ChangeFlag, JsonArray> calculated = AoCompare.diffPull(queueO, queueN, atom, ignoreSet);
        return apt.compared(calculated);
    }

    private static Kv<ChangeFlag, JsonObject> updateKv(ConcurrentMap<ChangeFlag, JsonArray> processed) {
        Kv changed = Kv.create();
        processed.forEach((flag, items) -> {
            if (1 == items.size()) {
                changed.set(flag, (Object)items.getJsonObject(0));
            }
        });
        return changed;
    }

    private static JsonArray updateQueue(JsonArray queueUTemp, DataAtom atom, Set<String> ignoreSet) {
        JsonArray queueU = new JsonArray();
        Vs vs = atom.vs().ignores(ignoreSet);
        Ut.itJArray((JsonArray)queueUTemp).filter(arg_0 -> ((Vs)vs).isChange(arg_0)).forEach(arg_0 -> ((JsonArray)queueU).add(arg_0));
        return queueU;
    }
}

