/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.apply;

import cn.vertxup.atom.domain.tables.pojos.MEntity;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.cv.em.KeyType;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.apply.AoDefault;
import io.vertx.up.util.Ut;
import java.util.Locale;
import java.util.TreeSet;

class KeyDefault
implements AoDefault {
    private transient MEntity entity;

    KeyDefault() {
    }

    @Override
    public <T> AoDefault mount(T mounted) {
        if (mounted instanceof MEntity) {
            this.entity = (MEntity)mounted;
        }
        return this;
    }

    @Override
    public void applyJson(JsonObject key) {
        if (null != this.entity) {
            Ao.debugUca(this.getClass(), "\u300cDFT\u300d\u952e\u8f93\u5165\u503c\uff1a{0}", key.encode());
            AoDefault.apply(key, "name", this.getName(key));
            AoDefault.apply(key, "entityId", this.entity.getKey());
            JsonArray columns = this.getColumns(key);
            key.put("columns", columns.encode());
            AoDefault.apply(key);
        } else {
            Ao.debugAtom(KeyDefault.class, "[OxE] key \u4f20\u5165\u7684\u5b9e\u4f53\u4e3a\u7a7a\uff01", new Object[0]);
        }
    }

    private String getName(JsonObject key) {
        KeyType type = (KeyType)Ut.toEnum(KeyType.class, (String)key.getString("type"));
        StringBuilder name = new StringBuilder();
        name.append(KeyType.PRIMARY == type ? "PK_" : "UK_");
        name.append(this.entity.getTableName()).append('_');
        JsonArray columns = this.getColumns(key);
        TreeSet columnSet = new TreeSet();
        columns.stream().map(column -> (String)column).forEach(columnSet::add);
        name.append(Ut.fromJoin(columnSet, (String)"_"));
        return name.toString().toUpperCase(Locale.getDefault());
    }

    private JsonArray getColumns(JsonObject key) {
        Object valueAdapter = key.getValue("columns");
        JsonArray array = new JsonArray();
        if (null != valueAdapter) {
            array = String.class == valueAdapter.getClass() ? new JsonArray(valueAdapter.toString()) : key.getJsonArray("columns");
        }
        return array;
    }
}

