/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.change;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.change.Adjuster;
import io.vertx.up.util.Ut;
import java.util.Date;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class AbstractAdjuster
implements Adjuster {
    private static final JsonObject ADJUST = Ao.adjuster();
    protected transient Class<?> type;

    public AbstractAdjuster(Class<?> type) {
        this.type = type;
    }

    private JsonObject config() {
        String simpleName = this.type.getSimpleName();
        JsonObject config = ADJUST.getJsonObject(simpleName);
        return Ut.isNil((JsonObject)config) ? new JsonObject().put("out", new JsonObject()).put("in", new JsonObject()) : config.copy();
    }

    protected JsonObject configOut() {
        return this.config().getJsonObject("out");
    }

    protected JsonObject configIn() {
        return this.config().getJsonObject("in");
    }

    protected String literal(Object input) {
        return Objects.isNull(input) ? null : input.toString().trim();
    }

    @Override
    public Object inValue(Object ucmdbInput) {
        return Ut.aiJValue((Object)ucmdbInput);
    }

    @Override
    public Object outValue(Object input) {
        return Ut.aiValue((Object)input, Date.class);
    }

    @Override
    public boolean isSame(Object oldValue, Object newValue) {
        return this.isSame(oldValue, newValue, () -> oldValue.toString().trim().equals(newValue.toString().trim()));
    }

    protected boolean isSame(Object oldValue, Object newValue, Supplier<Boolean> fnCompare) {
        if (Objects.isNull(oldValue) && Objects.isNull(newValue)) {
            return true;
        }
        if (Objects.nonNull(oldValue) && Objects.nonNull(newValue)) {
            return fnCompare.get();
        }
        String oldStr = Objects.isNull(oldValue) ? "" : oldValue.toString().trim();
        String newStr = Objects.isNull(newValue) ? "" : newValue.toString().trim();
        return oldStr.equals(newStr);
    }
}

