/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.change;

import io.vertx.tp.modular.change.AbstractAdjuster;
import io.vertx.up.util.Ut;

final class AjInteger
extends AbstractAdjuster {
    public AjInteger() {
        super(Integer.class);
    }

    @Override
    public Object inValue(Object ucmdbInput) {
        String liberal = this.literal(ucmdbInput);
        if (Ut.isInteger((String)liberal)) {
            return Integer.parseInt(liberal);
        }
        return this.parseUnit(liberal);
    }

    @Override
    public boolean isSame(Object oldValue, Object newValue) {
        String oldLiteral = this.literal(oldValue);
        String newLiteral = this.literal(newValue);
        return this.parseUnit(oldLiteral).equals(this.parseUnit(newLiteral));
    }

    private Integer parseUnit(String literal) {
        if (Ut.notNil((String)literal)) {
            String normalized = literal.replaceAll("(GB|TB|MB|G|T|M)", "").trim();
            return Ut.notNil((String)normalized) ? Integer.parseInt(normalized) : 0;
        }
        return 0;
    }
}

