/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.tp.atom.cv.AoCache;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.jooq.JQAggregate;
import io.vertx.tp.modular.jooq.JQDelete;
import io.vertx.tp.modular.jooq.JQInsert;
import io.vertx.tp.modular.jooq.JQQuery;
import io.vertx.tp.modular.jooq.JQUpdate;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.up.fn.Fn;
import org.jooq.DSLContext;

public class JQEngine {
    private final transient JQInsert insertTool;
    private final transient JQDelete deleteTool;
    private final transient JQQuery queryTool;
    private final transient JQUpdate updateTool;
    private final transient JQAggregate aggregateTool;

    private JQEngine(DSLContext context) {
        this.initSetting(context);
        this.insertTool = new JQInsert(context);
        this.deleteTool = new JQDelete(context);
        this.queryTool = new JQQuery(context);
        this.updateTool = new JQUpdate(context);
        this.aggregateTool = new JQAggregate(context);
    }

    public static JQEngine create(DSLContext context) {
        return (JQEngine)Fn.pool(AoCache.POOL_ENGINES, (Object)context.hashCode(), () -> new JQEngine(context));
    }

    public JQEngine bind(AoSentence sentence) {
        this.queryTool.bind(sentence);
        return this;
    }

    private void initSetting(DSLContext context) {
        boolean isSql = Ao.isDebug();
        if (isSql) {
            context.settings().setDebugInfoOnStackTrace(Boolean.TRUE);
        }
    }

    public DataEvent update(DataEvent event) {
        return this.updateTool.update(event);
    }

    public DataEvent updateBatch(DataEvent event) {
        return this.updateTool.updateBatch(event);
    }

    public DataEvent insert(DataEvent event) {
        return this.insertTool.insert(event);
    }

    public DataEvent insertBatch(DataEvent events) {
        return this.insertTool.insertBatch(events);
    }

    public DataEvent fetchByIds(DataEvent events) {
        return this.queryTool.fetchByIds(events);
    }

    public DataEvent fetchById(DataEvent event) {
        return this.queryTool.fetchById(event);
    }

    public DataEvent fetchOne(DataEvent event) {
        return this.queryTool.fetchOne(event);
    }

    public DataEvent fetchAll(DataEvent event) {
        return this.queryTool.fetchAll(event);
    }

    public DataEvent search(DataEvent event) {
        return this.queryTool.search(event);
    }

    public DataEvent query(DataEvent event) {
        return this.queryTool.query(event);
    }

    public DataEvent delete(DataEvent event) {
        return this.deleteTool.delete(event);
    }

    public DataEvent deleteBatch(DataEvent event) {
        return this.deleteTool.deleteBatch(event);
    }

    public DataEvent count(DataEvent event) {
        return this.aggregateTool.count(event);
    }
}

