/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.modular.jooq.JQTerm;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.tp.modular.query.Ingest;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.SelectWhereStep;

class JQQuery {
    private final transient DSLContext context;
    private final transient JQTerm term;

    JQQuery(DSLContext context) {
        this.context = context;
        this.term = new JQTerm(context);
    }

    JQQuery bind(AoSentence sentence) {
        this.term.bind(sentence);
        return this;
    }

    DataEvent query(DataEvent events) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doQueryAll(this.getClass(), events, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectSample(events, (Set<String>)tables, (Ingest)ingest);
            return query.fetchArray();
        }));
    }

    DataEvent fetchById(DataEvent event) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doRead(this.getClass(), event, (table, matrix) -> {
            SelectWhereStep query = this.context.selectFrom(Jq.toTable(table));
            Condition condition = Jq.onKey(matrix);
            query.where(new Condition[]{condition});
            return query.fetchOne();
        }));
    }

    DataEvent fetchByIds(DataEvent events) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doReads(this.getClass(), events, (table, matrixList) -> {
            SelectWhereStep query = this.context.selectFrom(Jq.toTable(table));
            Condition condition = Jq.onKeys(matrixList);
            query.where(new Condition[]{condition});
            return query.fetchArray();
        }));
    }

    DataEvent fetchOne(DataEvent event) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doQuery(this.getClass(), event, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectSample(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchOne();
        }));
    }

    DataEvent fetchAll(DataEvent event) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doQueryAll(this.getClass(), event, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectAll(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchArray();
        }));
    }

    DataEvent search(DataEvent event) {
        return (DataEvent)this.context.transactionResult(configuration -> Jq.doQuery(this.getClass(), event, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectComplex(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetchArray();
        }, (tables, ingest) -> {
            SelectWhereStep query = this.term.getSelectSample(event, (Set<String>)tables, (Ingest)ingest);
            return query.fetch().size();
        }));
    }
}

