/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.jooq.JQPre;
import io.vertx.tp.modular.query.Ingest;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.log.Annal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Condition;
import org.jooq.OrderField;

class JQToolkit {
    private static final Annal LOGGER = Annal.get(JQToolkit.class);

    JQToolkit() {
    }

    static Condition getCondition(DataEvent event, Ingest ingest, ConcurrentMap<String, String> map) {
        Condition condition;
        DataTpl tpl = event.getTpl();
        if (map.isEmpty()) {
            condition = ingest.onCondition(tpl, JQPre.prepare(tpl.atom(), event.getCriteria()));
            Ao.infoSQL(LOGGER, "\u5355\u8868, \u6700\u7ec8\u6761\u4ef6\uff1a{0}", condition);
        } else {
            condition = ingest.onCondition(tpl, JQPre.prepare(tpl.atom(), event.getCriteria()), map);
            Ao.infoSQL(LOGGER, "\u591a\u8868, \u6700\u7ec8\u6761\u4ef6\uff1a{0}", condition);
        }
        return condition;
    }

    static ConcurrentMap<String, String> getMap(Set<String> tables) {
        ConcurrentHashMap<String, String> tableMap = new ConcurrentHashMap<String, String>();
        if (1 < tables.size()) {
            String prefix = "T0";
            int index = 1;
            for (String table : tables) {
                String alias = "T0" + index;
                ++index;
                tableMap.put(table, alias);
            }
        }
        return tableMap;
    }

    static List<OrderField> getSorter(DataEvent event, Ingest ingest, ConcurrentMap<String, String> map) {
        ArrayList<OrderField> orders = new ArrayList<OrderField>();
        Sorter sorter = event.getSorter();
        if (Objects.nonNull(sorter)) {
            if (map.isEmpty()) {
                orders.addAll(ingest.onOrder(event.getTpl(), sorter));
            } else {
                orders.addAll(ingest.onOrder(event.getTpl(), sorter, map));
            }
        }
        return orders;
    }
}

