/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq.internal;

import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataRow;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.error._417ConditionEmptyException;
import io.vertx.tp.error._417DataTransactionException;
import io.vertx.up.exception.WebException;
import io.vertx.up.fn.Actuator;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jooq.Record;
import org.jooq.exception.DataAccessException;

class Data {
    private static final Annal LOGGER = Annal.get(Data.class);

    Data() {
    }

    static DataEvent doFinal(DataEvent event) {
        if (!event.succeed().booleanValue()) {
            WebException error = event.getError();
            if (null != error) {
                throw error;
            }
            LOGGER.error("[ Ox ] \u5f02\u5e38\u4e3a\u7a7a\uff0c\u4f46\u54cd\u5e94\u4e5f\u975e\u6cd5\u3002success = {0}", new Object[]{event.succeed()});
        }
        return event;
    }

    static void doExecute(Class<?> clazz, DataEvent event, Consumer<List<DataRow>> consumer) {
        Annal logger = Annal.get(clazz);
        try {
            List<DataRow> rows = event.getRows();
            if (null == rows || rows.isEmpty()) {
                LOGGER.error("[ Ox ] \u884c\u5f15\u7528\u4e3a\u7a7a\uff0cDataRow = null\u3002", new Object[0]);
            } else {
                consumer.accept(rows);
            }
        }
        catch (DataAccessException ex) {
            logger.jvm((Throwable)ex);
            _417DataTransactionException error = new _417DataTransactionException(clazz, ex);
            event.failure(error);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static <T> void doImpact(T expected, Predicate<T> predicate, Actuator actuator, Supplier<WebException> supplier) {
        if (null == predicate) {
            actuator.execute();
        } else if (predicate.test(expected)) {
            actuator.execute();
        } else {
            throw supplier.get();
        }
    }

    static Consumer<String> doJoin(List<DataRow> rows, Record[] records) {
        return table -> {
            for (int idx = 0; idx < rows.size(); ++idx) {
                DataRow row = (DataRow)rows.get(idx);
                if (null == row) continue;
                if (idx < records.length) {
                    Record record = records[idx];
                    row.success((String)table, record, (Set<String>)new HashSet<String>());
                    continue;
                }
                row.success((String)table, null, (Set<String>)new HashSet<String>());
            }
        };
    }

    static List<DataRow> doJoin(Set<String> tableSet, Record[] records, DataTpl tpl, Set<String> projection) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (Record record : records) {
            DataRow row = new DataRow(tpl);
            tableSet.forEach(table -> row.success((String)table, record, projection));
            rows.add(row);
        }
        return rows;
    }

    static void doInput(String table, DataMatrix matrix) {
        Fn.outWeb((boolean)matrix.getAttributes().isEmpty(), (Annal)LOGGER, _417ConditionEmptyException.class, (Object[])new Object[]{Data.class, table});
    }

    static void doInput(String table, List<DataMatrix> matrixList) {
        matrixList.forEach(matrix -> Data.doInput(table, matrix));
    }
}

