/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.query;

import cn.vertxup.atom.domain.tables.pojos.MField;
import cn.vertxup.atom.domain.tables.pojos.MJoin;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.atom.modeling.element.DataMatrix;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.jooq.internal.Jq;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.tp.modular.query.Ingest;
import io.vertx.tp.modular.query.QVisitor;
import io.vertx.up.atom.query.Criteria;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.atom.query.tree.QTree;
import io.vertx.up.log.Annal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

class JoinIngest
implements Ingest {
    private static final Annal LOGGER = Annal.get(JoinIngest.class);
    private transient AoSentence sentence;

    JoinIngest() {
    }

    @Override
    public Condition onCondition(DataTpl tpl, Criteria criteria, ConcurrentMap<String, String> aliasMap) {
        QTree tree = QTree.create((Criteria)criteria);
        Ao.infoSQL(LOGGER, "\uff08Join\u6a21\u5f0f\uff09\u67e5\u8be2\u5206\u6790\u6811\uff1a\n{0}", tree.toString());
        ConcurrentMap<String, DataMatrix> matrixs = tpl.matrixData();
        ConcurrentMap<String, String> prefixMap = this.calculatePrefix(matrixs, aliasMap);
        return QVisitor.analyze(tree, new HashSet<DataMatrix>(matrixs.values()), prefixMap);
    }

    private ConcurrentMap<String, String> calculatePrefix(ConcurrentMap<String, DataMatrix> matrixs, ConcurrentMap<String, String> aliasMap) {
        ConcurrentHashMap<String, String> fieldInfo = new ConcurrentHashMap<String, String>();
        matrixs.keySet().forEach(table -> {
            String prefix = (String)aliasMap.get(table);
            DataMatrix matrix = (DataMatrix)matrixs.get(table);
            matrix.getAttributes().forEach(attribute -> {
                String column = matrix.getColumn((String)attribute);
                fieldInfo.put(column, prefix);
            });
        });
        return fieldInfo;
    }

    @Override
    public Table<Record> onTable(DataTpl tpl, Set<String> tables, ConcurrentMap<String, String> aliasMap) {
        MJoin leader = tpl.joinLeader();
        if (Objects.isNull(leader)) {
            return Jq.natureJoin(aliasMap);
        }
        Schema schema = tpl.schema(leader.getEntity());
        String primary = schema.getTable();
        ConcurrentHashMap<String, String> joinedCols = new ConcurrentHashMap<String, String>();
        ConcurrentMap<String, String> joined = tpl.joinVoters();
        joined.forEach((table, field) -> {
            Schema tableObj = tpl.schema((String)table);
            MField fieldObj = tableObj.getField((String)field);
            String column = fieldObj.getColumnName();
            String wrapperCol = Objects.nonNull(this.sentence) ? this.sentence.columnDdl(column) : column;
            joinedCols.put(tableObj.getTable(), wrapperCol);
        });
        return Jq.leftJoin(primary, joinedCols, aliasMap);
    }

    @Override
    public List<OrderField> onOrder(DataTpl tpl, Sorter sorter, ConcurrentMap<String, String> aliasMap) {
        ArrayList<OrderField> orders = new ArrayList<OrderField>();
        JsonObject data = sorter.toJson();
        for (String field : data.fieldNames()) {
            String columnName = tpl.column(field);
            if (!Objects.nonNull(columnName)) continue;
            boolean isAsc = data.getBoolean(field);
            Field column = DSL.field((String)columnName);
            orders.add((OrderField)(isAsc ? column.asc() : column.desc()));
        }
        Ao.infoSQL(LOGGER, "\uff08Join\u6a21\u5f0f\uff09\u6392\u5e8f\u6761\u4ef6\uff1a{0}, size = {1}", data.encode(), orders.size());
        return orders;
    }

    @Override
    public Ingest bind(AoSentence sentence) {
        this.sentence = sentence;
        return this;
    }
}

