/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.reference;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.config.AoRule;
import io.vertx.tp.atom.modeling.reference.RDao;
import io.vertx.tp.atom.modeling.reference.RQuote;
import io.vertx.up.commune.Record;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class RaySource {
    private final transient RQuote quote;

    private RaySource(RQuote quote) {
        this.quote = quote;
    }

    static RaySource create(RQuote quote) {
        return new RaySource(quote);
    }

    public ConcurrentMap<String, JsonArray> fetchSingle(Record record) {
        return this.fetchData(rule -> rule.condition(record));
    }

    public ConcurrentMap<String, JsonArray> fetchBatch(Record[] records) {
        return this.fetchData(rule -> rule.condition(records));
    }

    private ConcurrentMap<String, JsonArray> fetchData(Function<AoRule, JsonObject> supplier) {
        ConcurrentHashMap<String, JsonArray> data = new ConcurrentHashMap<String, JsonArray>();
        this.quote.rules().forEach((field, rule) -> {
            JsonObject condition = (JsonObject)supplier.apply((AoRule)rule);
            RDao dao = this.quote.dao((String)field);
            JsonArray records = dao.fetchBy(condition);
            data.put((String)field, records);
        });
        return data;
    }
}

