/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.data;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import io.vertx.tp.atom.cv.em.AttributeType;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.modeling.config.AoAttribute;
import io.vertx.tp.atom.modeling.reference.RQuery;
import io.vertx.tp.atom.modeling.reference.RQuote;
import io.vertx.tp.atom.modeling.reference.RResult;
import io.vertx.up.eon.em.DataFormat;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class AoReference {
    private final transient ConcurrentMap<String, RQuote> references = new ConcurrentHashMap<String, RQuote>();
    private final transient ConcurrentMap<String, RResult> result = new ConcurrentHashMap<String, RResult>();
    private final transient ConcurrentMap<String, RQuery> queries = new ConcurrentHashMap<String, RQuery>();

    public AoReference(Model modelRef, String appName) {
        Set<MAttribute> attributes = modelRef.dbAttributes();
        attributes.stream().filter(Objects::nonNull).filter(attr -> Objects.nonNull(attr.getSource())).filter(attr -> !modelRef.identifier().equals(attr.getSource())).forEach(attribute -> {
            AoAttribute aoAttr = modelRef.attribute(attribute.getName());
            AttributeType type = (AttributeType)Ut.toEnum(attribute::getType, AttributeType.class, (Enum)AttributeType.INTERNAL);
            String source = attribute.getSource();
            if (AttributeType.REFERENCE == type) {
                RQuote quote = ((RQuote)Fn.pool(this.references, (Object)source, () -> RQuote.create(appName, source))).add((MAttribute)attribute, aoAttr);
                String field = attribute.getName();
                RResult result = (RResult)Fn.pool(this.result, (Object)field, () -> new RResult((MAttribute)attribute, aoAttr));
                if (DataFormat.Elementary == aoAttr.format()) {
                    Fn.pool(this.queries, (Object)field, () -> new RQuery(field, attribute.getSourceField()).bind(quote.dao(field)).bind(result.joined()));
                }
            }
        });
    }

    ConcurrentMap<String, RQuote> refInput() {
        return this.references;
    }

    ConcurrentMap<String, RQuery> refQr() {
        return this.queries;
    }

    ConcurrentMap<String, RResult> refOutput() {
        return this.result;
    }
}

