/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.element;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MField;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DataMatrix
implements Serializable {
    private final transient ConcurrentMap<String, String> attributeMap = new ConcurrentHashMap<String, String>();
    private final transient ConcurrentMap<String, Class<?>> typeMap = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, Object> valueMap = new ConcurrentHashMap<String, Object>();
    private final transient ConcurrentMap<String, String> revertMap = new ConcurrentHashMap<String, String>();
    private final transient Set<String> primaryKeys = new HashSet<String>();
    private transient AoSentence sentence;

    private DataMatrix() {
    }

    public static DataMatrix create() {
        return new DataMatrix();
    }

    public DataMatrix on(AoSentence sentence) {
        this.sentence = sentence;
        return this;
    }

    @Fluent
    public DataMatrix add(MField field, MAttribute attribute, Object value) {
        if (null == field || null == attribute) {
            Ao.debugAtom(this.getClass(), "Model Information\uff1a<namespace>.<identifier> = {0}, model = {1}", new Object[0]);
        } else {
            String columnName = this.wrapperColumn(field.getColumnName());
            String name = attribute.getName();
            Class type = Ut.clazz((String)field.getType());
            this.attributeMap.put(name, columnName);
            this.revertMap.put(columnName, name);
            this.typeMap.put(name, type);
            if (Objects.nonNull(value)) {
                this.valueMap.put(name, value);
            }
            if (field.getIsPrimary().booleanValue()) {
                this.primaryKeys.add(attribute.getName());
            }
        }
        return this;
    }

    @Fluent
    public DataMatrix add(MField field, MAttribute attribute) {
        return this.add(field, attribute, null);
    }

    @Fluent
    public DataMatrix set(String attribute, Object value) {
        Ao.debugAtom(this.getClass(), "Set key/value pair\uff1a{0} = {1}", attribute, value);
        if (Objects.nonNull(value) && this.attributeMap.containsKey(attribute)) {
            this.valueMap.put(attribute, value);
        }
        return this;
    }

    public DataMatrix copy() {
        DataMatrix that = new DataMatrix();
        that.sentence = this.sentence;
        this.attributeMap.forEach(that.attributeMap::put);
        this.typeMap.forEach(that.typeMap::put);
        this.revertMap.forEach(that.revertMap::put);
        that.primaryKeys.addAll(this.primaryKeys);
        return that;
    }

    private String wrapperColumn(String column) {
        String columnName = column;
        if (null != this.sentence) {
            columnName = this.sentence.columnDdl(columnName);
        }
        return columnName;
    }

    public Set<String> getAttributes() {
        return this.attributeMap.keySet();
    }

    public String getColumn(String field) {
        return (String)this.attributeMap.get(field);
    }

    public Set<String> getKeys() {
        return this.primaryKeys;
    }

    public String getField(String column) {
        String targetCol = this.wrapperColumn(column);
        return (String)this.revertMap.get(targetCol);
    }

    public Class<?> getType(String field) {
        return (Class)this.typeMap.get(field);
    }

    public Object getValue(String field) {
        return this.valueMap.get(field);
    }

    public void appendConsole(StringBuilder buffer) {
        buffer.append("| - \u4e3b\u952e\u5c5e\u6027\uff1a").append(Ut.fromJoin(this.primaryKeys)).append("\n");
        buffer.append(String.format("%-20s", "\u5b57\u6bb5\u540d")).append("\t");
        buffer.append(String.format("%-20s", "\u5217\u540d")).append("\t");
        buffer.append(String.format("%-40s", "\u7c7b\u578b")).append("\t");
        buffer.append(String.format("%-20s", "\u503c")).append("\n");
        this.attributeMap.forEach((field, column) -> {
            buffer.append(String.format("%-20s", field)).append("\t");
            buffer.append(String.format("%-20s", column)).append("\t");
            buffer.append(String.format("%-40s", this.typeMap.get(field))).append("\t");
            buffer.append(String.format("%-20s", this.valueMap.get(field))).append("\n");
        });
    }

    public void appendData(StringBuilder builder, Integer keyWidth) {
        this.attributeMap.forEach((field, column) -> {
            String item = "%-" + keyWidth + "s";
            Object value = this.getValue((String)field);
            builder.append(String.format(item, field)).append(String.format(item, value)).append("\n");
        });
    }
}

