/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom.modeling.reference;

import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.config.AoAttribute;
import io.vertx.tp.atom.modeling.config.AoRule;
import io.vertx.tp.atom.modeling.reference.RDao;
import io.vertx.tp.ke.atom.metadata.KJoin;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RQuote
implements Serializable {
    private final transient String source;
    private final transient String appName;
    private final transient ConcurrentMap<String, Class<?>> typeMap = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, AoAttribute> sourceConfig = new ConcurrentHashMap<String, AoAttribute>();
    private final transient ConcurrentMap<String, JsonObject> sourceReference = new ConcurrentHashMap<String, JsonObject>();
    private final transient ConcurrentMap<String, AoRule> sourceRule = new ConcurrentHashMap<String, AoRule>();
    private final transient ConcurrentMap<String, RDao> sourceDao = new ConcurrentHashMap<String, RDao>();

    private RQuote(String appName, String source) {
        this.source = source;
        this.appName = appName;
    }

    public static RQuote create(String appName, String source) {
        return new RQuote(appName, source);
    }

    @Fluent
    public RQuote add(MAttribute attribute, AoAttribute service) {
        String name = attribute.getName();
        this.sourceConfig.put(name, service);
        this.typeMap.put(name, service.typeCls());
        if (Objects.nonNull(attribute.getSourceReference())) {
            JsonObject sourceReference = Ut.toJObject((String)attribute.getSourceReference());
            this.sourceReference.put(name, sourceReference);
            AoRule rule = service.rule();
            this.sourceRule.put(name, rule);
            RDao dao = (RDao)Fn.pool(this.sourceDao, (Object)rule.keyDao(), () -> new RDao(this.appName, this.source));
            if (dao.isStatic() && sourceReference.containsKey("dao")) {
                KJoin join = (KJoin)Ut.deserialize((JsonObject)sourceReference.getJsonObject("dao"), KJoin.class);
                dao.bind(join);
            }
        }
        return this;
    }

    public ConcurrentMap<String, AoRule> rules() {
        return this.sourceRule;
    }

    public AoRule rule(String field) {
        return this.sourceRule.getOrDefault(field, null);
    }

    public RDao dao(String field) {
        AoRule rule = this.sourceRule.getOrDefault(field, null);
        return this.sourceDao.getOrDefault(rule.keyDao(), null);
    }

    public Class<?> type(String field) {
        return this.typeMap.getOrDefault(field, String.class);
    }
}

