/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.reference;

import io.vertx.tp.atom.modeling.data.DataAtom;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.atom.modeling.reference.RResult;
import io.vertx.tp.error._501AnonymousAtomException;
import io.vertx.tp.modular.reference.AoRay;
import io.vertx.tp.modular.reference.RaySource;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractRay<T>
implements AoRay<T> {
    protected transient DataTpl tpl;
    protected transient ConcurrentMap<String, RaySource> input = new ConcurrentHashMap<String, RaySource>();
    protected transient ConcurrentMap<String, RResult> output = new ConcurrentHashMap<String, RResult>();

    @Override
    public AoRay<T> on(DataTpl tpl) {
        this.tpl = tpl;
        DataAtom atom = tpl.atom();
        if (Objects.isNull(atom)) {
            throw new _501AnonymousAtomException(tpl.getClass());
        }
        atom.refInput().forEach((identifier, quote) -> {
            RaySource source = RaySource.create(quote);
            this.input.put((String)identifier, source);
        });
        this.output.putAll(atom.refOutput());
        return this;
    }

    @Override
    public T attach(T input) {
        if (this.input.isEmpty()) {
            return input;
        }
        return this.doAttach(input);
    }

    public abstract T doAttach(T var1);
}

