/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.ambient;

import cn.vertxup.atom.domain.tables.daos.MAttributeDao;
import cn.vertxup.atom.domain.tables.daos.MJoinDao;
import cn.vertxup.atom.domain.tables.daos.MModelDao;
import cn.vertxup.atom.domain.tables.pojos.MAttribute;
import cn.vertxup.atom.domain.tables.pojos.MJoin;
import cn.vertxup.atom.domain.tables.pojos.MModel;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.modeling.Model;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.optic.ambient.AoRefine;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

class ModelRefine
implements AoRefine {
    ModelRefine() {
    }

    public Function<JsonObject, Future<JsonObject>> apply() {
        return appJson -> {
            JsonArray modelJson = appJson.getJsonArray("models");
            String name = appJson.getString("name");
            Set<Model> models = this.toModels(modelJson, Model.namespace(name));
            Ao.infoUca(this.getClass(), "3. AoRefine.model(): {0}", String.valueOf(models.size()));
            ArrayList futures = new ArrayList();
            models.stream().map(this::saveModel).forEach(futures::add);
            return Ux.thenCombine(futures).compose(nil -> Ux.future((Object)appJson));
        };
    }

    private Set<Model> toModels(JsonArray modelJson, String namespace) {
        HashSet<Model> models = new HashSet<Model>();
        Ut.itJArray((JsonArray)modelJson).map(data -> Model.instance(namespace, data)).forEach(models::add);
        return models;
    }

    private JsonObject onCriteria(MAttribute attribute) {
        JsonObject filters = new JsonObject();
        filters.put("name", attribute.getName());
        filters.put("modelId", attribute.getModelId());
        return filters;
    }

    private JsonObject onCriteria(MModel entity) {
        JsonObject filters = new JsonObject();
        filters.put("namespace", entity.getNamespace());
        filters.put("identifier", entity.getIdentifier());
        return filters;
    }

    private JsonObject onCriteria(MJoin nexus) {
        JsonObject filters = new JsonObject();
        filters.put("namespace", nexus.getNamespace());
        filters.put("model", nexus.getModel());
        return filters;
    }

    private Future<JsonObject> saveModelAsync(Model model) {
        Promise promise = Promise.promise();
        WorkerExecutor executor = Ux.nativeWorker((String)("model - " + model.identifier()));
        executor.executeBlocking(pre -> pre.handle(this.saveModel(model)), post -> promise.complete(post.result()));
        return promise.future();
    }

    private Future<JsonObject> saveModel(Model model) {
        ArrayList futures = new ArrayList();
        model.dbAttributes().stream().map(attr -> Ux.Jooq.on(MAttributeDao.class).upsertAsync(this.onCriteria((MAttribute)attr), attr).compose(Ux::futureJ)).forEach(futures::add);
        Ao.infoUca(this.getClass(), "3.1. Processing model: {0}", model.identifier());
        model.dbJoins().stream().map(nexus -> Ux.Jooq.on(MJoinDao.class).deleteByAsync(this.onCriteria((MJoin)nexus)).compose(nil -> Ux.Jooq.on(MJoinDao.class).insertAsync(nexus)).compose(Ux::futureJ)).forEach(futures::add);
        return Ux.thenCombine(futures).compose(nil -> Ux.Jooq.on(MModelDao.class).upsertAsync(this.onCriteria(model.dbModel()), (Object)model.dbModel())).compose(Ux::futureJ);
    }
}

